<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die;
$uploading = new StdClass();
$uploading->const = JText::_('UPDATING');
$uploading->updated = JText::_('UPDATED');
$uploading->error = JText::_('UPDATED_ERROR');
$uploading->url = JUri::root();
$uploading = json_encode($uploading);
$tagsApp = null;
$installedBlog = gridboxHelper::checkInstalledBlog();
?>
<script type="text/javascript"><?php echo gridboxHelper::getGridboxLanguage(); ?></script>
<input type="hidden" value="<?php echo htmlentities($uploading); ?>" id="update-data">
<div class="tour-parent">
    <div class="product-tour sidebar-tour step-1">
        <div>
            <i class="zmdi zmdi-close"></i>
            <p class="ba-group-title"><?php echo JText::_('SINGLE_PAGES'); ?></p>
            <p><?php echo JText::_('CREATE_REGULAR_PAGES'); ?></p>
            <a class="ba-btn next"><?php echo JText::_('NEXT'); ?></a>
        </div>
    </div>
    <div class="product-tour sidebar-tour step-2">
        <div>
            <i class="zmdi zmdi-close"></i>
            <p class="ba-group-title"><?php echo JText::_('APPS'); ?></p>
            <p><?php echo JText::_('IMPROVE_WEBSITE_FUNCTIONALITY'); ?></p>
            <a class="ba-btn next"><?php echo JText::_('NEXT'); ?></a>
        </div>
    </div>
    <div class="product-tour sidebar-tour step-3">
        <div>
            <i class="zmdi zmdi-close"></i>
            <p class="ba-group-title"><?php echo JText::_('TRASH_FOLDER'); ?></p>
            <p><?php echo JText::_('RECOVER_DELETED_PAGES'); ?></p>
            <a class="ba-btn next"><?php echo JText::_('NEXT'); ?></a>
        </div>
    </div>
    <div class="product-tour sidebar-tour step-4">
        <div>
            <i class="zmdi zmdi-close"></i>
            <p class="ba-group-title"><?php echo JText::_('THEMES'); ?></p>
            <p><?php echo JText::_('FIND_THEME_FOR_WEBSITE'); ?></p>
            <a class="ba-btn close"><?php echo JText::_('CLOSE'); ?></a>
        </div>
    </div>
</div>
<div class="ba-sidebar">
    <div class="top-icons">
        <div class="scroll-sidebar <?php echo $installedBlog == 0 ? 'installed-blog' : ''; ?>">
            <span class="single-pages <?php echo gridboxHelper::checkActive('pages'); ?>">
                <a href="index.php?option=com_gridbox&view=pages" class="default-action">
                    <span class="zmdi zmdi-file"></span>
                    <span class="sidebar-items-title"><?php echo JText::_('SINGLE_PAGES'); ?></span>
                </a>
                <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_('SINGLE_PAGES'); ?></span>
            </span>
        <?php
            foreach ($this->apps as $key => $app) {
                if ($app->type == 'tags') {
                    $tagsApp = $app;
                    continue;
                }
        ?>
            <span class="app <?php echo gridboxHelper::checkActive($app); ?>" data-id="<?php echo $app->id; ?>">
                <a href="<?php echo gridboxHelper::getUrl($app); ?>" class="default-action">
                    <span class="<?php echo gridboxHelper::getIcon($app); ?>"></span>
                    <span class="sidebar-items-title"><?php echo $app->title; ?></span>
                </a>
                <span class="ba-tooltip ba-right ba-hide-element"><?php echo $app->title; ?></span>
            </span>
        <?php
            }
        ?>   
        </div>
    </div>
    <div class="bottom-icons">
        <div class="ba-system-actions">
            <span class="add-new-app <?php echo gridboxHelper::appClassName(); ?>">
                <a href="#">
                    <span class="zmdi zmdi-plus-circle"></span>
                    <span class="sidebar-items-title"><?php echo JText::_('ADD_NEW_APP'); ?></span>
                    <i class="zmdi zmdi-caret-right"></i>
                </a>
                <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_('ADD_NEW_APP'); ?></span>
            </span>
<?php
            if ($installedBlog > 0) {
?>
            <span class="app <?php echo gridboxHelper::checkActive($tagsApp); ?>" data-id="<?php echo $tagsApp->id; ?>">
                <a href="<?php echo gridboxHelper::getUrl($tagsApp); ?>">
                    <span class="<?php echo gridboxHelper::getIcon($tagsApp); ?>"></span>
                    <span class="sidebar-items-title"><?php echo JText::_($tagsApp->title); ?></span>
                </a>
                <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_($tagsApp->title); ?></span>
            </span>
            <span class="authors-pages <?php echo gridboxHelper::checkActive('authors'); ?>">
                <a href="index.php?option=com_gridbox&view=authors">
                    <span class="zmdi zmdi-account-circle"></span>
                    <span class="sidebar-items-title"><?php echo JText::_('AUTHORS'); ?></span>
                </a>
                <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_('AUTHORS'); ?></span>
            </span>
<?php
            }
?>
            <span class="system-pages <?php echo gridboxHelper::checkActive('system'); ?>">
                <a href="index.php?option=com_gridbox&view=system">
                    <span class="zmdi zmdi-alert-polygon"></span>
                    <span class="sidebar-items-title"><?php echo JText::_('SYSTEM_PAGES'); ?></span>
                </a>
                <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_('SYSTEM_PAGES'); ?></span>
            </span>
            <span class="trashed-items <?php echo gridboxHelper::checkActive('trashed'); ?>">
                <a href="index.php?option=com_gridbox&view=trashed">
                    <span class="zmdi zmdi-delete"></span>
                    <span class="sidebar-items-title"><?php echo JText::_('TRASHED_ITEMS'); ?></span>
                </a>
                <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_('TRASHED_ITEMS'); ?></span>
            </span>
        </div>
        <span class="gridbox-themes <?php echo gridboxHelper::checkActive('themes'); ?>">
            <a href="index.php?option=com_gridbox&view=themes">
                <span class="zmdi zmdi-format-color-fill"></span>
                <span class="sidebar-items-title"><?php echo JText::_('THEMES'); ?></span>
            </a>
            <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_('THEMES'); ?></span>
        </span>
        <span class="gridbox-help">
            <a href="#">
                <span class="zmdi zmdi-help"></span>
                <span class="sidebar-items-title"><?php echo JText::_('HELP'); ?></span>
                <i class="zmdi zmdi-caret-right"></i>
            </a>
            <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_('HELP'); ?></span>
        </span>
        <span class="gridbox-options">
            <a href="#">
                <span class="zmdi zmdi-settings"></span>
                <span class="sidebar-items-title"><?php echo JText::_('OPTIONS'); ?></span>
                <i class="zmdi zmdi-caret-right"></i>
            </a>
            <span class="ba-tooltip ba-right ba-hide-element"><?php echo JText::_('OPTIONS'); ?></span>
        </span>
        <span class="open-sidebar">
            <a href="#">
                <span class="zmdi zmdi-caret-right"></span>
            </a>
        </span>
    </div>
</div>
<div class="sidebar-backdrop"></div>
<div id='login-modal' class='ba-modal-sm modal hide'>
    <div class='modal-body'>
        <div class="ba-login-dialog">
            <div class="ba-header-content">
                <h3 class='ba-modal-header'>
                    <?php echo JText::_('LOGIN'); ?>
                </h3>
                <label class="ba-help-icon">
                    <i class="zmdi zmdi-help"></i>
                    <span class="ba-tooltip ba-help ba-hide-element">
                        <?php echo JText::_('LOGIN_TOOLTIP'); ?>
                    </span>
                </label>
            </div>
            <div class="ba-body-content">
                <div class="ba-input-lg">
                    <input class='ba-username reset-input-margin' type='text' autocomplete="off"
                        placeholder="<?php echo JText::_('USERNAME'); ?>">
                    <span class="focus-underline"></span>
                </div>
                <div class="ba-input-lg">
                    <input class='ba-password' type='password' name="ba-password" autocomplete="off"
                        placeholder="<?php echo JText::_('PASSWORD'); ?>">
                    <span class="focus-underline"></span>
                </div>
                <input type="hidden" id="theme-id">
            </div>
            <div class="ba-footer-content">
                <a href="#" class="ba-btn-primary login-button active-button">
                    <?php echo JText::_('INSTALL'); ?>
                </a>
            </div>
        </div>
    </div>
</div>