<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class gridboxViewSystem extends JViewLegacy
{
    protected $items;
    protected $pagination;
    protected $state;
    protected $about;
    protected $themes;
    protected $apps;
    
    public function display($tpl = null) 
    {
        $this->items = $this->get('Items');
        $this->state = $this->get('State');
        $app = JFactory::getApplication();
        $this->about = gridboxHelper::aboutUs();
        $this->apps = gridboxHelper::getApps();
        $this->items = $this->getThemeName($this->items);
        $this->pagination = $this->get('Pagination');
        $this->themes = $this->get('Themes');
        $this->addToolBar();
        foreach ($this->items as &$item) {
            $item->order_up = true;
            $item->order_dn = true;
        }
        $doc = JFactory::getDocument();
        $doc->addStyleSheet('components/com_gridbox/assets/css/ba-admin.css?'.$this->about->version);
        $doc->addScript('https://www.balbooa.com/updates/gridbox/gridboxApi/admin/gridboxApi.js');

        parent::display($tpl);
    }

    protected function addToolBar()
    {
        JToolBarHelper::custom('pages.options', 'options.png', 'options.png', 'SETTINGS', true);
    }

    protected function getThemeName($items)
    {
        $db = JFactory::getDbo();
        foreach ($items as $item) {
            $query = $db->getQuery(true);
            $query->select('`title`')
                ->from('#__template_styles')
                ->where('`id` = '.$db->quote($item->theme));
            $db->setQuery($query);
            $item->themeName = $db->loadResult();
        }
        
        return $items;
    }
    
    protected function getSortFields()
    {
        return array(
            'title' => JText::_('JGLOBAL_TITLE'),
            'order_list' => JText::_('CUSTOM'),
            'theme' => JText::_('THEME'),
            'id' => JText::_('JGRID_HEADING_ID')
        );
    }

    public static function preferences()
    {
        $uri = (string) JUri::getInstance();
        $return = urlencode(base64_encode($uri));
        $url = 'index.php?option=com_config&amp;view=component&amp;component=com_gridbox&amp;path=&amp;return=' .$return;
        
        return $url;
    }
}