<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die;

// import Joomla controllerform library
jimport('joomla.application.component.controllerform');
jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class gridboxControllergridbox extends JControllerForm
{
    public function getModel($name = 'gridbox', $prefix = 'gridboxModel', $config = array())
	{
		return parent::getModel($name, $prefix, array('ignore_request' => false));
	}

    public function compressImage()
    {
        $image = $_GET['image'];
        $dir = JPATH_ROOT.$image;
        $ext = strtolower(JFile::getExt($dir));
        $imageCreate = $this->imageCreate($ext);
        $imageSave = $this->imageSave($ext);
        $size = gridboxHelper::$website->images_max_size * 1;
        $quality = gridboxHelper::$website->images_quality * 1;
        header("Content-type: image/".$ext);
        $path = JPATH_ROOT.'/images/compressed';
        $array = explode('/', $image);
        $name = array_pop($array);
        $n = count($array);
        if (!JFolder::exists($path)) {
            JFolder::create($path);
        }
        for ($i = 2; $i < $n; $i++) {
            $path .= '/'.$array[$i];
            if (!JFolder::exists($path)) {
                JFolder::create($path);
            }
        }
        $path .= '/'.$name;
        $exists = JFile::exists($path);
        if (!$exists && !$im = $imageCreate($dir)) {
            $path = $dir;
        } else if (!$exists) {
            $width = imagesx($im);
            $height = imagesy($im);
            if ($width <= $size && $height <= $size) {
                $w = $width;
                $h = $height;
            } else {
                $ratio = $width / $height;
                if ($width > $height) {
                    $w = $size;
                    $h = $size / $ratio;
                } else {
                    $h = $size;
                    $w = $size * $ratio;
                }
            }
            $out = imagecreatetruecolor($w, $h);
            if ($ext == 'png') {
                imagealphablending($out, false);
                imagesavealpha($out, true);
                $transparent = imagecolorallocatealpha($out, 255, 255, 255, 127);
                imagefilledrectangle($out, 0, 0, $w, $h, $transparent);
            }
            imagecopyresampled($out, $im, 0, 0, 0, 0, $w, $h, $width, $height);
            if ($ext == 'png') {
                $quality = 9 - round($quality / 11.111111111111);
            }
            $imageSave($out, $path, $quality);
            imagedestroy($out);
            imagedestroy($im);
        }
        $f = fopen($path, "r");
        fpassthru($f);
        exit;
    }

    public function imageSave($type) {
        switch ($type) {
            case 'png':
                $imageSave = 'imagepng';
                break;
            default:
                $imageSave = 'imagejpeg';
        }

        return $imageSave;
    }

    public function imageCreate($type) {
        switch ($type) {
            case 'png':
                $imageCreate = 'imagecreatefrompng';
                break;
            default:
                $imageCreate = 'imagecreatefromjpeg';
        }
        return $imageCreate;
    }

    public function login()
    {
        $input = JFactory::getApplication()->input;
        $login = $input->get('ba_login', '', 'string');
        $password = $input->get('ba_password', '', 'string');
        $credentials = array('username' => $login, 'password' => $password);
        $msg = '';
        if (!JFactory::getApplication()->login($credentials)) {
            $msg = JText::_('LOGIN_ERROR');
        }
        echo $msg;
        exit;
    }

    public function createPage()
    {
        gridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $id = $model->createPage();

        echo $id;
        exit;
    }

    public function getSession()
    {
        $session = JFactory::getSession();
        echo new JResponseJson($session->getState());
        exit;
    }

    public function save($key = NULL, $urlVar = NULL)
    {
        
    }
}