<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die;

// import Joomla controllerform library
jimport('joomla.application.component.controllerform');
jimport('joomla.filesystem.file');
jimport('joomla.filesystem.folder');

class gridboxControllerIcons extends JControllerForm
{
    public function getModel($name = '', $prefix = '', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, array('ignore_request' => false));
	}

    public function addCustomIcons()
    {
        gridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $obj = new stdClass();
        $icon = $name = $_POST['icon_name'];
        $name = str_replace(' ', '+', $name);
        $file = gridboxHelper::replace($name);
        $file = JFile::makeSafe($file.'.zip');
        $name = str_replace('-', '', $file);
        $name = str_replace('zip', '', $name);
        $name = str_replace('.', '', $name);
        if ($name == '') {
            $file = date("Y-m-d-H-i-s").'.zip';
        }
        $name = strtolower($file);
        $fileName = str_replace('.zip', '', $name);
        $dir = JPATH_ROOT. '/templates/gridbox/library/icons/custom-icons';
        if (!JFolder::exists($dir)) {
            JFolder::create($dir);
        }
        if (JFolder::exists($dir.'/'.$fileName)) {
            $obj->msg = JText::_('ICONS_ALREADY_INSTALLED');
            $obj->type = 'ba-alert';
        } else {
            JFile::upload($_FILES['custom-files']['tmp_name'], $dir.'/'.$name);
            if (!JFolder::exists($dir.'/tmp')) {
                JFolder::create($dir.'/tmp');
            }
            JFolder::create($dir.'/'.$fileName);
            JArchive::extract($dir.'/'.$name, $dir.'/tmp/'.$fileName);
            JFile::delete($dir.'/'.$name);
            $model->installIcons($fileName, $icon);
            JFolder::delete($dir.'/tmp');
            $obj->msg = JText::_('ICONS_IS_ADDED');
            $obj->type = '';
        }
        echo json_encode($obj);
        exit;
    }
    
    public function delete()
    {
        gridboxHelper::checkUserEditLevel();
        $model = $this->getModel();
        $model->delete();
        echo JText::_('COM_GRIDBOX_N_ITEMS_DELETED');
        exit;
    }
}