/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

!function ($) {
    
    var carousel = function (element, options) {
        this.parent = $(element);
        this.modal = null;
        this.modalImage = null;
        this.options = options;
        this.options.count *= 1;
        this.currentIndex = 0;
        this.content = this.parent.find('.slideshow-content');
        this.childrens = this.content.find('li.item');
        this.firstOrder = this.childrens.last();
        this.startCoords = {};
        this.endCoords = {};
        this.flag = true;
    }
    
    carousel.prototype = {

        init : function(){
            var $this = this,
                count = this.options.count,
                margin = this.options.gutter ? 30 : 0;
            this.parent.find('.ba-slideset-dots').remove();
            if (this.options.pause) {
                this.parent.on('mouseenter.slideset', $.proxy(this.pause, this)).on('mouseleave.slideset', $.proxy(this.cycle, this));
            }
            this.parent.find('.active').removeClass('active');
            this.parent.find('.first-order-element').removeClass('first-order-element')
            this.firstOrder.addClass('first-order-element');
            this.content.css('left', '');
            this.content.removeClass('move-started');
            this.childrens.css('order', '');
            this.cycle();
            if (this.childrens.length > this.options.count && !this.parent.hasClass('slideshow-type')) {
                this.firstOrder.css('order', 1);
                var left = 'calc(((100% - '+(margin * (count - 1))+'px) / -'+count+') - '+margin+'px)';
                if (this.options.overflow) {
                    left = 'calc((100% / '+count+') * -1)'
                }
                this.content.css({
                    left: left,
                    transition: 'none'
                });
                this.content.on('mousedown.carousel', function(event){
                    var width = $(window).width(),
                        mousemove = 0,
                        startX = event.clientX;
                    $this.content.css({
                        transition: 'none'
                    });
                    $(document).on('mousemove.carousel', function(event){
                        var delta = startX - event.clientX,
                            calc = '(((100% - '+(margin * (count - 1))+'px) / -'+count+') - '+margin+'px)';
                        mousemove = startX - event.clientX;
                        if (mousemove != 0) {
                            $this.content.addClass('move-started');
                            $this.content.css({
                                transform: 'translateX(calc('+calc+' * '+(delta / width)+'))'
                            }).attr('data-transform', calc+' * '+(delta / width));
                        }
                        return false;
                    }).on('mouseup.carousel', function(event){
                        $(document).off('mousemove.carousel mouseup.carousel')
                        if (mousemove != 0) {
                            $this.content.removeClass('move-started');
                            if (event.clientX > startX) {
                                $this.parent.find('[data-slide="prev"]').trigger('click');
                            } else if (event.clientX < startX) {
                                $this.parent.find('[data-slide="next"]').trigger('click');
                            }
                        }                            
                    });
                    return false;
                });
            } else if (this.parent.hasClass('slideshow-type')) {
                this.firstOrder = this.childrens.first();
                this.firstOrder.addClass('active');
                this.parent.find('.first-order-element').removeClass('first-order-element');
                this.parent.removeClass('first-load-slideshow');
            }
            this.childrens.find('.ba-slideshow-img').on('mousedown.carousel', function(event){
                if ($this.content.hasClass('lightbox-enabled')) {
                    event.stopPropagation();
                }
            }).on('click.carousel', function(event){
                if ($this.content.hasClass('lightbox-enabled')) {
                    $this.modalImage = this;
                    var bgImage = $this.getImageURI();
                    if (bgImage) {
                        $this.pause();
                        $this.openModal(bgImage, this);
                    }
                }
            });
            this.parent.find('[data-slide]').on('click.slideset',  function(event){
                event.preventDefault();
                var action = this.dataset.slide,
                    el = $this[action]($this.firstOrder);
                $this.slide(el, action);
            });
            this.parent.on('touchstart.slideset', function(event){
                $this.endCoords = event.originalEvent.targetTouches[0];
                $this.startCoords = event.originalEvent.targetTouches[0];
            });
            this.parent.on('touchmove.slideset', function(event){
                $this.endCoords = event.originalEvent.targetTouches[0];
            });
            this.parent.on('touchend.slideset', function(event){
                var hDistance = $this.endCoords.pageX - $this.startCoords.pageX,
                    xabs = Math.abs($this.endCoords.pageX - $this.startCoords.pageX),
                    yabs = Math.abs($this.endCoords.pageY - $this.startCoords.pageY);
                if(hDistance >= 100 && xabs >= yabs * 2) {
                    $this.parent.find('[data-slide="prev"]').trigger('click');
                } else if (hDistance <= -100 && xabs >= yabs * 2) {
                    $this.parent.find('[data-slide="next"]').trigger('click');
                }
            });
        },
        getImageURI: function(){
            var styles = getComputedStyle(this.modalImage),
                match = styles.backgroundImage.match(/url\(([^\)]*)\)/),
                bgImage = null;
            if (match) {
                bgImage = match[1];
                if (bgImage.indexOf('h') !== 0) {
                    bgImage = bgImage.substring(1, bgImage.length - 1)
                }
            }

            return bgImage;
        },
        setSimpleImage: function(image) {
            var modal = this.modal,
                imgHeight = image.naturalHeight,
                imgWidth = image.naturalWidth,
                wWidth = $g(window).width(),
                wHeigth = $g(window).height(),
                percent = imgWidth / imgHeight;
            if (wWidth > 1024) {
                if (imgWidth < wWidth && imgHeight < wHeigth) {
                
                } else {
                    if (imgWidth > imgHeight) {
                        imgWidth = wWidth - 100;
                        imgHeight = imgWidth / percent;
                    } else {
                        imgHeight = wHeigth - 100;
                        imgWidth = percent * imgHeight;
                    }
                    if (imgHeight > wHeigth) {
                        imgHeight = wHeigth - 100;
                        imgWidth = percent * imgHeight;
                    }
                    if (imgWidth > wWidth) {
                        imgWidth = wWidth - 100;
                        imgHeight = imgWidth / percent;
                    }
                }
            } else {
                percent = imgWidth / imgHeight;
                if (percent >= 1) {
                    imgWidth = wWidth * 0.90;
                    imgHeight = imgWidth / percent;
                    if (wHeigth - imgHeight < wHeigth * 0.1) {
                        imgHeight = wHeigth * 0.90;
                        imgWidth = imgHeight * percent;
                    }
                } else {
                    imgHeight = wHeigth * 0.90;
                    imgWidth = imgHeight * percent;
                    if (wWidth - imgWidth < wWidth * 0.1) {
                        imgWidth = wWidth * 0.90;
                        imgHeight = imgWidth / percent;
                    }
                }
            }
            var modalTop = (wHeigth - imgHeight) / 2,
                left = (wWidth - imgWidth) / 2;
            setTimeout(function(){
                modal.find('> div').css({
                    'background-image': 'url('+image.src+')',
                    'width' : Math.round(imgWidth),
                    'height' : Math.round(imgHeight),
                    'left' : Math.round(left),
                    'top' : Math.round(modalTop)
                }).addClass('instagram-fade-animation');
            }, 1);
        },
        simpleGetPrev: function(){
            var el = $(this.modalImage).closest('li.item'),
                $this = this;
            if (el.prev().length > 0) {
                el = el.prev();
            } else {
                el = this.childrens.last();
            }
            this.modalImage = el.find('.ba-slideshow-img')[0];
            var bgImage = this.getImageURI();
            if (bgImage) {
                var image = document.createElement('img');
                image.onload = function(){
                    $this.setSimpleImage(this);
                }
                image.src = bgImage;
            }
        },
        simpleGetNext: function(img, images, index){
            var el = $(this.modalImage).closest('li.item'),
                $this = this;
            if (el.next().length > 0) {
                el = el.next();
            } else {
                el = this.childrens.first();
            }
            this.modalImage = el.find('.ba-slideshow-img')[0];
            var bgImage = this.getImageURI();
            if (bgImage) {
                var image = document.createElement('img');
                image.onload = function(){
                    $this.setSimpleImage(this);
                }
                image.src = bgImage;
            }
        },
        simpleModalClose: function(modal, images, index){
            var $this = this;
            this.modal.addClass('image-lightbox-out');
            setTimeout(function(){
                $this.modal.remove();
                $this.cycle();
            }, 500);
        },
        openModal: function(src, original){
            var image = document.createElement('img'),
                $this = this,
                div = document.createElement('div'),
                origImage = $(original),
                key = origImage.closest('.ba-item').attr('id'),
                width = origImage.width(),
                height = origImage.height(),
                offset = origImage.offset(),
                imgHeight = this.naturalHeight,
                imgWidth = this.naturalWidth,
                wWidth = $g(window).width(),
                wHeigth = $g(window).height(),
                percent = imgWidth / imgHeight,
                img = document.createElement('div');
            $this.modal = $g(div);
            img.style.top = (offset.top - $g(window).scrollTop())+'px';
            img.style.left = offset.left+'px';
            img.style.width = width+'px';
            img.style.height = height+'px';
            div.className = 'ba-image-modal instagram-modal carousel-modal';
            div.style.backgroundColor = app.getCorrectColor(app.items[key].lightbox.color);
            div.appendChild(img);
            $this.modal.on('click', function(){
                $this.simpleModalClose();
            });
            $g('body').append(div);
            image.onload = function(){
                $this.setSimpleImage(this);
                setTimeout(function(){
                    var str = '<i class="zmdi zmdi-chevron-left"></i><i class="zmdi zmdi-chevron-right"></i>';
                    str += '<i class="zmdi zmdi-close">';
                    $this.modal.append(str);
                    $this.modal.find('.zmdi-chevron-left').on('click', function(event){
                        event.stopPropagation();
                        $this.simpleGetPrev();
                    });
                    $this.modal.find('.zmdi-chevron-right').on('click', function(event){
                        event.stopPropagation();
                        $this.simpleGetNext();
                    });
                    $this.modal.find('.zmdi-close').on('click', function(event){
                        event.stopPropagation();
                        $this.simpleModalClose();
                    });
                }, 600);
            }
            image.src = src;
        },
        cycle: function(event){
            if (this.options.autoplay == 1) {
                this.flag = true;
                if (this.interval) {
                    clearInterval(this.interval);
                }
                this.interval = setInterval($.proxy(this.cycleAction, this), this.options.delay);

                return this;
            }
        },
        pause: function(){
            if (this.interval) {
                clearInterval(this.interval);
            }
            this.interval = null;
            this.flag = false;
        },
        delete: function(){
            clearInterval(this.interval);
            this.interval = null;
            this.parent.off('mouseenter.slideset mouseleave.slideset');
            this.parent.find('[data-slide]').off('click.slideset');
            this.parent.off('touchstart.slideset touchmove.slideset touchend.slideset');
            this.parent.find('.ba-next, .ba-prev, .ba-left, .ba-right').removeClass('ba-next ba-prev ba-left ba-right');
            this.content.off('mousedown.carousel');
            this.childrens.find('.ba-slideshow-img').off('mousedown.carousel click.carousel');
        },
        slide: function(el, action){
            if (this.childrens.length > this.options.count && !this.parent.hasClass('slideshow-type')) {
                var $this = this,
                    count = this.options.count,
                    margin = this.options.gutter ? 30 : 0,
                    delta = action == 'next' ? 1 : -1,
                    left = 'calc(((100% - '+(margin * (count - 1))+'px) / -'+count+') - '+margin+'px)',
                    calc = "((100% + "+margin+"px) / "+(count * delta)+')';
                this.firstOrder.removeClass('first-order-element');
                this.firstOrder = el.addClass('first-order-element').css('order', 1);
                for (i = j = 2, len = this.childrens.length; (2 <= len ? j <= len : j >= len); i = 2 <= len ? ++j : --j) {
                    el = this.next(el).css('order', i);
                }
                if (this.options.overflow) {
                    left = 'calc(((100% / '+count+') * -1)';
                }
                if (this.content[0].dataset.transform) {
                    calc += ' + '+this.content[0].dataset.transform;
                    this.content[0].dataset.transform = '';
                }
                this.content.css({
                    'transform': 'translateX(calc('+calc+'))',
                    'left': left,
                    'transition': 'none'
                });
                setTimeout((function() {
                    $this.content.css({
                        'transform': '',
                        'transition': 'transform 0.5s linear'
                    });
                }), 50);
                if (this.flag) {
                    this.cycle();
                }
            } else if (this.parent.hasClass('slideshow-type')) {
                var active = this.parent.find('.item.active'),
                    fallback  = action == 'next' ? 'first' : 'last';
                this.parent.removeClass('first-load-slideshow');
                this.parent.find('.select-animation').removeClass('select-animation');
                if (el.hasClass('active')) {
                    return;
                }
                this.parent.find('.ba-next, .ba-prev, .ba-left, .ba-right').removeClass('ba-next ba-prev ba-left ba-right');
                if (fallback == 'first') {
                    active.addClass('ba-next').addClass('burns-out');
                    el.addClass('ba-right');
                } else {
                    active.addClass('ba-prev').addClass('burns-out');
                    el.addClass('ba-left');
                }
                setTimeout(function(){
                    active.removeClass('burns-out');
                }, 600);
                active.removeClass('active');
                this.firstOrder = el.addClass('active');

            }
        },
        next: function(el){
            if (el.next().length > 0) {
                return el.next();
            } else {
                return this.childrens.first();
            }
        },
        prev: function(el){
            if (el.prev().length > 0) {
                return el.prev();
            } else {
                return this.childrens.last();
            }
        },
        cycleAction: function (){
            this.parent.find('.slideset-btn-next').trigger('click');
        }
    }
    
    $.fn.carousel = function(option){
        return this.each(function(){
            var $this = $(this),
                data = $this.data('carousel'),
                options = $.extend({}, $.fn.carousel.defaults, typeof option == 'object' && option);
            if (data) {
                data.delete();
                $this.removeData();
            }
            $this.data('carousel', (data = new carousel(this, options)));
            data.init();
        });
    }
    
    $.fn.carousel.defaults = {
        delay: 3000,
        autoplay: true,
        pause: false,
        mode: 'set',
        gutter: true,
        count: 3
    }
}(window.$g ? window.$g : window.jQuery);