/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

var file = document.createElement('link'),
    color = '',
    sortingList = new Array(),
    fontBtn = '',
    toolbarButtons = {
        'text-decoration' : true,
        'text-transform' : true,
        'font-style' : true,
        'text-align' : true
    };
file.rel = 'stylesheet';
file.href = JUri+'media/jui/css/jquery.minicolors.css';
document.getElementsByTagName('head')[0].appendChild(file);
file = document.createElement('script');
file.src = JUri+'components/com_gridbox/libraries/minicolors/jquery.minicolors.js';
file.onload = function(){
    $g('.variables-color-picker').minicolors({
        opacity: true,
        theme: 'bootstrap',
        change: function(hex, opacity) {
            var rgba = $g(this).minicolors('rgbaString');
            fontBtn.value = hex;
            $g('.variables-color-picker').closest('#color-picker-cell')
                .find('.minicolors-opacity').val(opacity * 1);
            fontBtn.dataset.rgba = rgba;
            $g(fontBtn).trigger('minicolorsInput').next().find('.minicolors-swatch-color')
                .css('background-color', rgba).closest('.ba-settings-item')
                .find('.minicolors-opacity').val(opacity * 1).removeAttr('readonly');
        }
    });
    $g('.color-variables-group').on('click', '.color-variables-item', function(){
        var variable = this.dataset.variable,
            value = app.editor.app.theme.colorVariables[variable].color,
            color = rgba2hex(value);
        fontBtn.value = variable;
        fontBtn.dataset.rgba = variable;
        $g(fontBtn).trigger('minicolorsInput').next().find('.minicolors-swatch-color')
            .css('background-color', value).closest('.ba-settings-item')
            .find('.minicolors-opacity').val('').attr('readonly', true);
        $g(this).trigger('mouseleave');
        $g('#color-variables-dialog').modal('hide');
    });
    $g('#color-variables-dialog').on('show', function(){
        $g(this).find('.color-variables-item').each(function(){
            var color = app.editor.app.theme.colorVariables[this.dataset.variable].color;
            $g(this).find('.color-varibles-color-swatch').css('background-color', color);
        });
    }).on('hide', function(){
        app.addHistory();
    });
}
app.modules.helper = true;
document.getElementsByTagName('head')[0].appendChild(file);
file = document.createElement('script');
file.src = JUri+'components/com_gridbox/libraries/sortable/sortable.js';
file.onload = function(){
    $g('#intro-post-settings-dialog .sorting-container').sortable({
        handle : '.sorting-handle i',
        selector : '> .sorting-item',
        change : function(){
            var div = document.createElement('div'),
                wrapper = app.editor.document.querySelector('#'+app.editor.app.edit+' .intro-post-wrapper');
            $g('#intro-post-settings-dialog .sorting-container .sorting-item').each(function(){
                var key = this.dataset.key.replace('title', 'title-wrapper').replace('image', 'image-wrapper');
                div.appendChild(wrapper.querySelector('.intro-post-'+key));
            });
            $g(div.children).each(function(){
                wrapper.appendChild(this)
            });
            app.addHistory();
        },
        group : 'tabs'
    });
    $g('#content-slider-settings-dialog .sorting-container').sortable({
        handle : '.sorting-handle i',
        selector : '> .sorting-item',
        change : function(){
            var content = app.editor.$g(app.selector+' > .slideset-wrapper > ul > .slideshow-content'),
                li = content.find(' > li.item'),
                array = new Array();
                obj = {};
            $g('#content-slider-settings-dialog .sorting-container .sorting-item').each(function(key){
                obj[key] = sortingList[this.dataset.key];
                array.push(sortingList[this.dataset.key]);
                content.append(li[this.dataset.key]);
                this.dataset.key = key;
            });
            sortingList = array;
            app.edit.slides = obj;
            var object = {
                data : app.edit,
                selector : app.editor.app.edit
            }
            app.editor.app.checkModule('initItems', object);
            app.addHistory();
        },
        group : 'tabs'
    });
    $g('#tabs-settings-dialog .sorting-container').sortable({
        handle : '.sorting-handle i',
        selector : '> .sorting-item',
        change : function(){
            if (app.edit.type == 'tabs') {
                var ul = app.editor.document.querySelector('#'+app.editor.app.edit+' ul.nav-tabs'),
                    str = '';
                $g('#tabs-settings-dialog .sorting-container .sorting-item').each(function(){
                    var key = this.dataset.key;
                    str += '<li class="'+sortingList[key].className+'"><a href="'+sortingList[key].href;
                    str += '" data-toggle="tab"><span><span class="tabs-title';
                    if (!sortingList[key].title) {
                        str += ' empty-textnode';
                    }
                    str += '">'+sortingList[key].title+'</span>';
                    if (sortingList[key].icon) {
                        str += '<i class="'+sortingList[key].icon+'"></i>';
                    }
                    str += '</span></a></li>';
                });
                ul.innerHTML = str;
            } else {
                var parent = app.editor.document.querySelector('#'+app.editor.app.edit+' > .accordion'),
                    div = document.createElement('div');
                $g('#tabs-settings-dialog .sorting-container .sorting-item').each(function(){
                    var key = this.dataset.key,
                        child = app.editor.document.getElementById(sortingList[key].href.replace('#', ''));
                    div.appendChild(child.parentNode);
                });
                parent.innerHTML = div.innerHTML;
            }
            app.addHistory();
        },
        group : 'tabs'
    });
    $g('#menu-settings-dialog .one-page-options .sorting-container').sortable({
        handle : '.sorting-handle i',
        selector : '> .sorting-item',
        change : function(){
            var ul = app.editor.document.querySelector('#'+app.editor.app.edit+' ul.nav.menu'),
                str = '';
            $g('#menu-settings-dialog .one-page-options .sorting-container .sorting-item').each(function(){
                var key = this.dataset.key;
                str += '<li><a href="'+sortingList[key].href;
                str += '" data-alias="'+sortingList[key].alias+'">'+sortingList[key].title+'</a></li>';
            });
            ul.innerHTML = str;
            app.addHistory();
        },
        group : 'tabs'
    });
    $g('#menu-settings-dialog .menu-options > .sorting-container').sortable({
        handle : '> .sorting-item-wrapper > .sorting-item > .sorting-handle i',
        selector : '> .sorting-item-wrapper',
        change : function(dragEl){
            sortMenuItems();
        },
        group : 'menu-items'
    });
    $g('#slideshow-settings-dialog .sorting-container').sortable({
        handle : '.sorting-handle i',
        selector : '> .sorting-item',
        change : function(){
            var div = app.editor.document.querySelector('#'+app.editor.app.edit+' .slideshow-content'),
                object = {
                    'desktop' : {
                        'slides' : {}
                    }
                };
            for (var ind in app.editor.breakpoints) {
                object[ind] = {
                    slides : {}
                }
                if (!app.edit[ind]) {
                    app.edit[ind] = {};
                }
            }
            div.innerHTML = '';
            $g('#slideshow-settings-dialog .sorting-container .sorting-item').each(function(ind){
                var key = this.dataset.key,
                    str = getSlideHtml(sortingList[key]);
                div.appendChild(str);
                if (sortingList[key].button.embed) {
                    var a = app.editor.$g(div).find(' > li:last-child .slideshow-button a');
                    replaceSlideEmbed(a, sortingList[key].button);
                }
                for (var index in object) {
                    if (app.edit[index].slides && app.edit[index].slides[sortingList[key].index]) {
                        object[index].slides[ind + 1] = app.edit[index].slides[sortingList[key].index];
                    }
                }
                sortingList[key].index = ind + 1;
            });
            for (var ind in object) {
                app.edit[ind].slides = object[ind].slides;
            }
            app.sectionRules();
            var object = {
                data : app.edit,
                selector : app.editor.app.edit
            }
            app.editor.app.checkModule('initItems', object);
            app.addHistory();
        },
        group : 'slide'
    });
    $g('#item-settings-dialog .sorting-container').sortable({
        handle : '.sorting-handle i',
        selector : '> .sorting-item',
        change : function(){
            var wrapper = app.editor.$g('#'+app.editor.app.edit+' .instagram-wrapper'),
                array = sortingList;
            sortingList = [];
            wrapper.find('.ba-instagram-image').remove();
            $g('#item-settings-dialog .sorting-container .sorting-item').each(function(){
                var str = '<div class="ba-instagram-image"><img><div class="ba-simple-gallery-image"></div>'+
                    '<div class="ba-simple-gallery-caption"><div class="ba-caption-overlay"></div>'+
                    '<'+app.edit.tag+' class="ba-simple-gallery-title"></'+app.edit.tag+
                    '><div class="ba-simple-gallery-description"></div></div></div>';
                if (wrapper.find('.empty-list').length > 0) {
                    wrapper.find('.empty-list').before(str);
                } else {
                    wrapper.append(str);
                }
                var image = wrapper.find('.ba-instagram-image').last(),
                    obj = array[this.dataset.key],
                    src = obj.src,
                    img = image.find('img')[0];
                if (src.indexOf('balbooa.com') == -1) {
                    src = JUri+src;
                }
                image[0].style.backgroundImage = 'url('+src+')';
                img.src = src;
                img.dataset.src = obj.src;
                img.alt = obj.alt;
                image.find('.ba-simple-gallery-title').addClass(!obj.title ? 'empty-content' : '').text(obj.title);
                image.find('.ba-simple-gallery-description').addClass(!obj.description ? 'empty-content' : '').text(obj.description);
                sortingList.push(obj)
            });
            
            $g('#item-settings-dialog .sorting-container').html('');
            for (var i = 0; i < sortingList.length; i++) {
                $g('#item-settings-dialog .sorting-container').append(addSimpleSortingList(sortingList[i], i));
            }
            app.addHistory();
        },
        group : 'slide'
    });
    $g('#social-icons-settings-dialog .sorting-container').sortable({
        handle : '.sorting-handle i',
        selector : '> .sorting-item',
        change : function(){
            var obj = {};
            $g('#social-icons-settings-dialog .sorting-container .sorting-item').each(function(ind){
                obj[ind] = sortingList[this.dataset.key];
            });
            getSocialIconsHtml(obj);
            app.edit.icons = obj;
            app.addHistory();
        },
        group : 'slide'
    });
}
document.getElementsByTagName('head')[0].appendChild(file);

app.sectionRules = function(){
    var obj = {
        callback : 'sectionRules',
    }
    app.editor.app.listenMessage(obj);
}

app.setTypography = function(parent, target, subgroup){
    var obj = app.edit.desktop[target],
        parentObject = app.editor.app.theme.desktop,
        fontKey = 'body';
    if (app.view != 'desktop') {
        parent.find('.desktop-only').hide();
    } else if (target != 'links') {
        parent.find('.desktop-only').removeAttr('style');
    }
    if (!subgroup) {
        parent.find('[data-group]').attr('data-group', target);
    } else {
        obj = app.edit.desktop[target][subgroup];
    }
    if (app.edit.type == 'text' || app.edit.type == 'headline') {
        obj = app.editor.app.theme.desktop[target];
        fontKey = target;
    }
    if (app.editor.$g(app.selector).closest('footer.footer').length > 0) {
        parentObject = app.editor.app.footer.desktop;
    }
    var parentFont = parentObject[fontKey]['font-family'];
    if (parentFont == '@default') {
        parentFont = parentObject.body['font-family'];
    }
    for (var key in obj) {
        var element = parent.find('[data-option="'+key+'"][data-group="'+target+'"]'),
            display = '',
            val = app.getValue(target, key);
        if (subgroup) {
            val = app.getValue(target, key, subgroup);
            element = parent.find('[data-option="'+key+'"][data-group="'+target+'"][data-subgroup="'+subgroup+'"]');
        }
        if ((app.edit.type == 'text' || app.edit.type == 'headline') && val == undefined) {
            val = getTextTypographyValue(target, key);
            display = 'none';
        } else if ((app.edit.type == 'text' || app.edit.type == 'headline')
            && app.edit[app.view][target] && val != app.edit[app.view][target][key]) {
            display = 'none';
        }
        if (key == 'font-family'){
            var family = val == '@default' ? gridboxLanguage['INHERIT'] : val.replace(/\+/g, ' '),
                wrapper = $g('.font-family-wrapper').empty(),
                p = null;
            element.val(family).attr('data-value', val);
            if (target != 'body') {
                p = document.createElement('p');
                p.innerHTML = '<span class="font-weight-title">'+gridboxLanguage['BASE_FONT_FAMILY']+
                    '</span><span class="font-family-title">'+parentFont.replace(/\+/g, ' ')+'</span>';
                p.style.fontFamily = "'"+parentFont.replace(/\+/g, ' ')+"'";
                p.dataset.value = '@default';
                wrapper.append(p);
            }
            for (var ind in fontsLibrary) {
                p = document.createElement('p');
                p.textContent = ind.replace(/\+/g, ' ');
                p.dataset.value = ind;
                p.style.fontFamily = "'"+ind.replace(/\+/g, ' ')+"'";
                wrapper.append(p);
                if (ind == val || (val == '@default' && ind == parentFont)) {
                    var weightWrapper = $g('.font-weight-wrapper').empty();
                    if (target != 'body') {
                        var str = '<span class="font-weight-title">'+gridboxLanguage['BASE_FONT_WEIGHT'],
                            inheritFont = ind,
                            inheritWeight = parentObject[fontKey]['font-weight'];
                        if (inheritFont == '@default') {
                            inheritFont = parentObject[fontKey]['font-family'];
                        }
                        if (inheritFont == '@default') {
                            inheritFont = parentObject['body']['font-family'];
                        }
                        if (inheritWeight == '@default') {
                            inheritWeight = parentObject['body']['font-weight'];
                        }
                        str += '</span><span class="font-family-title">'+inheritWeight.replace('i', 'Italic')+'</span>';
                        var p = document.createElement('p');
                        p.dataset.value = '@default';
                        p.style.fontFamily = "'"+inheritFont.replace(/\+/g, ' ')+"'";
                        p.style.fontWeight = inheritWeight.replace('i', '');
                        p.style.fontStyle = inheritWeight.indexOf('i') == -1 ? 'normal' : 'italic';
                        p.innerHTML = str;
                        weightWrapper.append(p);
                    }
                    for (var i = 0; i < fontsLibrary[ind].length; i++) {
                        var weight = fontsLibrary[ind][i].styles,
                            str = '<span class="font-weight-title">'+weight.replace('i', ' Italic')+
                            '</span><span class="font-family-title">'+ind.replace(/\+/g, ' ')+'</span>';
                        p = document.createElement('p');
                        p.dataset.value = weight;
                        p.style.fontFamily = "'"+ind.replace(/\+/g, ' ')+"'";
                        p.style.fontWeight = weight.replace('i', '');
                        p.style.fontStyle = weight.indexOf('i') == -1 ? 'normal' : 'italic';
                        p.innerHTML = str;
                        weightWrapper.append(p)
                    }
                }
            }
        } else if (key == 'font-weight') {
            var weight = val == '@default' ? gridboxLanguage['INHERIT'] : val.replace('i', ' Italic');
            element.val(weight).attr('data-value', val);
        } else if (toolbarButtons[key]) {
            element.each(function(){
                if (this.dataset.value == val) {
                    $g(this).addClass('active');
                } else {
                    $g(this).removeClass('active');
                }
            });
        } else if (key == 'color' || key == 'hover-color' || key == 'hover') {
            updateInput(element, val);
        } else {
            if (app.edit.type == 'text' || app.edit.type == 'headline') {
                element.closest('.ba-settings-item').find('> div:last-child').css('display', display);
            }
            var range = element.val(val).prev().val(val);
            setLinearWidth(range);
        }
    }
}

$g('input[type="text"][data-option="font-family"]').on('click', function(){
    if (!$g('#font-family-dialog').hasClass('in')) {
        createFontFamilyList();
        var rect = this.getBoundingClientRect(),
            wrapper = $g('.font-family-wrapper');
        fontBtn = this;
        wrapper.find('p').not('p[data-value="@default"]').remove();
        for (var ind in fontsLibrary) {
            var p = document.createElement('p');
            p.textContent = ind.replace(/\+/g, ' ');
            p.dataset.value = ind;
            p.style.fontFamily = "'"+ind.replace(/\+/g, ' ')+"'";
            wrapper.append(p);
        }
        $g('#font-family-dialog .active').removeClass('active');
        $g('#font-family-dialog p[data-value="'+this.dataset.value+'"]').addClass('active');
        $g('#font-family-dialog').css({
            left : rect.left - 285,
            top : rect.bottom - ((rect.bottom - rect.top) / 2) - 174
        }).modal();
    }
});

$g('input[type="text"][data-option="font-weight"]').on('click', function(){
    if (!$g('#font-weight-dialog').hasClass('in')) {
        createFontFamilyList();
        var rect = this.getBoundingClientRect();
        fontBtn = this;
        $g('#font-weight-dialog .active').removeClass('active');
        $g('#font-weight-dialog p[data-value="'+this.dataset.value+'"]').addClass('active');
        $g('#font-weight-dialog').css({
            left : rect.left - 285,
            top : rect.bottom - ((rect.bottom - rect.top) / 2) - 174
        }).modal();
    }
});

$g('.open-font-library').on('click', function(){
    $g('.show-font-library').trigger('mousedown');
});

$g('.font-family-wrapper').on('click', 'p[data-value]', function(){
    fontBtn.dataset.value = this.dataset.value;
    fontBtn.value = this.dataset.value == '@default' ? gridboxLanguage['INHERIT'] : this.dataset.value.replace(/\+/g, ' ');
    $g(fontBtn).trigger('change');
    $g('#font-family-dialog').modal('hide');
});

$g('.font-weight-wrapper').on('click', 'p[data-value]', function(){
    fontBtn.dataset.value = this.dataset.value;
    fontBtn.value = this.dataset.value == '@default' ? gridboxLanguage['INHERIT'] : this.dataset.value.replace(/\+/g, ' ');
    $g(fontBtn).trigger('change');
    $g('#font-weight-dialog').modal('hide');
});

function createFontFamilyList()
{
    var link = '',
        str = '';
    for (var ind in fontsLibrary) {
        if (!fontsLibrary[ind][0].custom_src) {
            link += ind+":";
            for (var i = 0; i < fontsLibrary[ind].length; i++) {
                link += fontsLibrary[ind][i].styles;
                if (i < fontsLibrary[ind].length - 1) {
                    link += ',';
                }
            }
            link += '%7C';
        } else {
            str += "@font-face {font-family: '"+ind.replace(/\+/g, ' ')+"';";
            str += 'font-weight : '+fontsLibrary[ind][0].styles+';';
            str += ' src: url('+JUri+'templates/gridbox/library/fonts/'+fontsLibrary[ind][0].custom_src+');}';
        }
    }
    if (link) {
        link = link.substring(0, link.length - 3);
        link += '&subset=latin,cyrillic,greek,latin-ext,greek-ext,vietnamese,cyrillic-ext';
        var file = document.createElement('link');
        file.rel = 'stylesheet';
        file.type = 'text/css';
        file.href = '//fonts.googleapis.com/css?family='+link;
        document.head.appendChild(file);
    }
    if (str) {
        var file = document.createElement('style');
        file.innerHTML = str;
        document.head.appendChild(file);
    }
}

function getSocialIconsHtml(obj)
{
    var wrapper = app.editor.$g(app.selector+' .ba-icon-wrapper').empty();
    for (var ind in obj) {
        var str = '<a href="'+obj[ind].link.link+'" target="'+obj[ind].link.target;
        str += '"><i class="'+obj[ind].icon+' ba-btn-transition"></i></a>';
        wrapper.append(str);
    }
    app.editor.app.buttonsPrevent();
}

function addSlideSortingList(obj, key)
{
    var str = '<div class="sorting-item" data-key="'+key;
    str += '"><div class="sorting-handle"><i class="zmdi zmdi-apps"></i></div>';
    str += '<div class="sorting-image">';
    if (!obj.video) {
        var src = obj.image;
        if (src.indexOf('balbooa.com') == -1) {
            src = app.editor.JUri+obj.image;
        }
        str += '<img src="'+src+'">';
    } else {
        str += '<i class="zmdi zmdi-play-circle-outline"></i>'
    }
    str += '</div><div class="sorting-title">';
    if (obj.video) {
        str += 'Video';
    } else {
        var title = obj.image.split('/');
        str += title[title.length - 1];
    }
    str += '</div><div class="sorting-icons">';
    str += '<span><i class="zmdi zmdi-edit"></i></span>';
    str += '<span><i class="zmdi zmdi-copy"></i></span>';
    str += '<span><i class="zmdi zmdi-delete"></i></span></div></div>';

    return str;
}

function addSortingList(obj, key)
{
    var str = '<div class="sorting-item" data-key="'+key;
    str += '"><div class="sorting-handle"><i class="zmdi zmdi-apps"></i></div>';
    str += '<div class="sorting-title">';
    if (obj.title) {
        str += obj.title;
    } else if (obj.icon) {
        str += obj.icon.replace('zmdi zmdi-', '').replace('fa fa-', '');
    }
    str += '</div><div class="sorting-icons">';
    str += '<span><i class="zmdi zmdi-edit"></i></span>';
    if (app.edit.type != 'menu') {
        str += '<span><i class="zmdi zmdi-copy"></i></span>';
    }
    str += '<span><i class="zmdi zmdi-delete"></i></span></div></div>';

    return str;
}

function editClass(val, target, obj)
{
    clearTimeout(delay);
    delay = setTimeout(function(){
        if (obj.suffix != 'ba-section' && obj.suffix != 'ba-row' && obj.suffix != 'ba-grid-column' && obj.suffix != 'ba-item') {
            var classNames = obj.suffix.split(' ');
            if (target == 'body') {
                target = app.editor.document.body;
            } else {
                target = app.editor.document.getElementById(target);
            }
            classNames.forEach(function(el, ind){
                if (el) {
                    target.classList.remove(el);
                }
            });
        }
        obj.suffix = val;
        classNames = obj.suffix.split(' ');
        classNames.forEach(function(el, ind){
            if (el) {
                target.classList.add(el);
            }
        });
        app.addHistory();
    }, 300);
}

function updateInput(input, rgba)
{
    if (rgba.indexOf('@') === 0) {
        var color = new Array(),
            bg = '';
        if (app.editor.app.theme.colorVariables[rgba]) {
            bg = app.editor.app.theme.colorVariables[rgba].color;
        }
        color.push(rgba);
        color.push('');
    } else {
        var color = rgba2hex(rgba),
            bg = rgba;
    }
    $g(input).attr('data-rgba', rgba).val(color[0]).next().find('.minicolors-swatch-color').css('background-color', bg);
    input.closest('.ba-settings-item').find('.minicolors-opacity').val(color[1]);
}

function rgba2hex(rgb)
{
    var parts = rgb.toLowerCase().match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/),
        hex = '#',
        part,
        color = new Array();
    if (parts) {
        for (var i = 1; i <= 3; i++) {
            part = parseInt(parts[i]).toString(16);
            if (part.length < 2) {
                part = '0'+part;
            }
            hex += part;
        }
        if (!parts[4]) {
            parts[4] = 1;
        }
        color.push(hex);
        color.push(parts[4] * 1);
        
        return color;
    } else {
        color.push(rgb.trim());
        color.push(1);
        
        return color;
    }
}

function setTabsAnimation()
{
    $g('.general-tabs ul').off('show').on('show', function(event){
        event.stopPropagation();
        var ind = new Array(),
            ul = $g(event.currentTarget),
            id = $g(event.relatedTarget).attr('href'),
            aId = $g(event.target).attr('href');
        ul.find('li a').each(function(i){
            if (this == event.target) {
                ind[0] = i;
            }
            if (this == event.relatedTarget) {
                ind[1] = i;
            }
        });
        if (ind[0] > ind[1]) {
            $g(id).addClass('out-left');
            $g(aId).addClass('right');
            setTimeout(function(){
                $g(id).removeClass('out-left');
                $g(aId).removeClass('right');
            }, 500);
        } else {
            $g(id).addClass('out-right');
            $g(aId).addClass('left');
            setTimeout(function(){
                $g(id).removeClass('out-right');
                $g(aId).removeClass('left');
            }, 500);
        }
        if ((event.target.hash == '#section-general-options' || event.target.hash == '#section-layout-options')
            && app.edit && app.edit.type == 'flipbox') {
            if (app.edit.side != 'frontside') {
                app.edit.side = 'frontside';
                app.editor.setFlipboxSide(app.edit, app.edit.side);
                var duration = app.getValue('animation', 'duration');
                app.editor.$g(app.selector).addClass('flipbox-animation-started').removeClass('backside-fliped');
                setTimeout(function(){
                    app.editor.$g(app.selector).removeClass('backside-fliped');
                }, duration * 1000);
                setSectionBackgroundOptions();
                $g('.flipbox-select-side input[type="hidden"]').val(app.edit.side);
                $g('.flipbox-select-side input[type="text"]').val(gridboxLanguage[app.edit.side.toUpperCase()]);
            }
        }
    }).on('shown', function(event){
        event.stopPropagation();
    });
    $g('.general-tabs a').off('show').on('show', function(event){
        var parent = $g(this).closest('.general-tabs'),
            prev = event.relatedTarget.getBoundingClientRect(),
            next = event.target.getBoundingClientRect();

        parent.find('.tabs-underline').stop().css({
            'left' : prev.left,
            'right' : document.documentElement.clientWidth - prev.right,
        }).show().animate({
            'left' : next.left,
            'right' : document.documentElement.clientWidth - next.right,
        }, 500, function(){
            parent.find('.tabs-underline').hide()
        });
    });
}

function setDisableState(search)
{
    var parent = $g(search),
        value = Boolean(app.edit.desktop.disable * 1);
    parent.find('input[data-option="disable"][data-group="desktop"]').prop('checked', value);
    for (var key in app.editor.breakpoints) {
        if (!app.edit[key] || typeof(app.edit[key].disable) == 'undefined') {
            continue;
        }
        value = Boolean(app.edit[key].disable * 1);
        parent.find('input[data-option="disable"][data-group="'+key+'"]').prop('checked', value);
    }
    if (!app.edit.access_view) {
        app.edit.access_view = 1;
    }
    parent.find('.section-access-view-select input[type="hidden"]').val(app.edit.access_view);
    value = parent.find('.section-access-view-select li[data-value="'+app.edit.access_view+'"]').text();
    parent.find('.section-access-view-select input[readonly]').val(value.trim());
    var item = app.editor.$g(app.selector);
    if (item.closest('.ba-menu-wrapper').length > 0 && item.closest('.ba-wrapper[data-megamenu]').length == 0) {
        parent.find('input[data-option="disable"][data-group="desktop"]').prop('checked', true).prop('disabled', true);
    } else {
        parent.find('input[data-option="disable"][data-group="desktop"]').prop('disabled', false);
    }
}

function getCategoryHtml(id, title)
{
    var str = '<li class="chosen-category"><span>'+title;
    str += '</span><i class="zmdi zmdi-close" data-remove="'+id+'"></i></li>';

    return str;
}

function showSlideshowDesign(search, select)
{
    var parent = $g(select).closest('.tab-pane');
    parent.children().not('.slideshow-design-group').hide();
    parent.find('.last-element-child').removeClass('last-element-child');
    parent.find('.slideshow-typography-hover').hide();
    parent.find('.ba-style-intro-options').hide();
    parent.find('.title-html-tag').hide();
    switch (search) {
        case 'title' :
            parent.find('.title-html-tag').css('display', '')
        case 'description' :
        case 'intro' :
        case 'info' :
            if (app.edit.type == 'recent-posts-slider' && (search == 'title' || search == 'info')) {
                parent.find('.slideshow-typography-hover').css('display', '').find('[data-subgroup]').attr('data-group', search);
            }
            if (search == 'intro') {
                parent.find('.ba-style-intro-options').css('display', '');
            }
            parent.find('.slideshow-margin-options').css('display', '').addClass('last-element-child')
                .find('[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-margin-options [data-type="reset"][data-subgroup="margin"]').attr('data-option', search);
            parent.find('.slideshow-typography-color')[0].style.display = '';
            parent.find('.slideshow-typography-options').css('display', '')
                .find('[data-subgroup="typography"]').attr('data-group', search);
            parent.find('.slideshow-animation-options').css('display', '').find('[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-typography-options .typography-options').addClass('ba-active-options');
            setTimeout(function(){
                parent.find('.slideshow-typography-options .typography-options').removeClass('ba-active-options');
            }, 1);
            break;
        case 'button' :
            parent.find('.slideshow-typography-color').hide();
            parent.find('.slideshow-typography-options').css('display', '').find('[data-subgroup="typography"]').attr('data-group', search);
            parent.find('.slideshow-animation-options').css('display', '').find('[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-margin-options').css('display', '').find('[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-margin-options [data-type="reset"][data-subgroup="margin"]').attr('data-option', search);
            parent.find('.slideshow-normal-options').css('display', '').find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-hover-options').css('display', '').find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-button-options').css('display', '').find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-border-options').css('display', '').find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-shadow-options').css('display', '').addClass('last-element-child')
                .find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-typography-options .typography-options').addClass('ba-active-options');
            setTimeout(function(){
                parent.find('.slideshow-typography-options .typography-options').removeClass('ba-active-options');
            }, 1);
            break;
        case 'arrows' :
            parent.find('.slideshow-normal-options').css('display', '').find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-hover-options').css('display', '').find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-arrows-options').css('display', '').find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-border-options').css('display', '').find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-shadow-options').css('display', '').addClass('last-element-child')
                .find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-normal-options, .slideshow-hover-options, .slideshow-arrows-options')
                .addClass('ba-active-options');
            setTimeout(function(){
                parent.find('.slideshow-normal-options, .slideshow-hover-options, .slideshow-arrows-options')
                    .removeClass('ba-active-options');
            }, 1);
            break;
        case 'dots' :
            parent.find('.slideshow-dots-options').css('display', '').addClass('last-element-child')
                .find('input[data-subgroup]').attr('data-group', search);
            parent.find('.slideshow-dots-options').addClass('ba-active-options');
            setTimeout(function(){
                parent.find('.slideshow-dots-options').removeClass('ba-active-options');
            }, 1);
            break;
        case 'image' :
            parent.find('.slideshow-image-options').css('display', '').last().addClass('last-element-child');
            setTimeout(function(){
                parent.find('.slideshow-image-options').removeClass('ba-active-options');
            }, 1);
            break;
    }
    parent.find('.last-element-child').nextAll().not('.slideshow-design-group').each(function(){
        if (this.style.display != 'none') {
            parent.find('.last-element-child').removeClass('last-element-child');
            return false;
        }
    });
    if (app.edit.type != 'recent-posts-slider') {
        parent.find('.last-element-child').removeClass('last-element-child');
    }
    if (app.edit.type != 'slideshow') {
        parent.find('.slideshow-animation-options').hide();
    }
    value = app.getValue(search);
    for (var ind in value) {
        if (typeof(value[ind]) == 'object') {
            if (ind == 'typography') {
                app.setTypography(parent.find('.slideshow-typography-options .typography-options'), search, ind);
            } else {
                if (ind == 'animation' && !(delay in value.animation)) {
                    value.animation.delay = 0;
                }
                for (var key in value[ind]) {
                    var input = parent.find('[data-group="'+search+'"][data-option="'+key+'"][data-subgroup="'+ind+'"]');
                    if (input.attr('data-type') == 'color') {
                        updateInput(input, value[ind][key]);
                    } else if (input.attr('type') == 'number') {
                        var range = input.prev();
                        input.val(value[ind][key]);
                        range.val(value[ind][key]);
                        setLinearWidth(range);
                    } else  {
                        input.val(value[ind][key]);
                        if (input.attr('type') == 'hidden') {
                            var text = input.closest('.ba-custom-select').find('li[data-value="'+value[ind][key]+'"]').text();
                            input.closest('.ba-custom-select').find('input[readonly]').val($g.trim(text));
                        }
                    }
                }
            }
        } else {
            var input = parent.find('[data-group="'+search+'"][data-option="'+ind+'"]'),
                range = input.prev();
            input.val(value[ind]);
            range.val(value[ind]);
            setLinearWidth(range);
        }
    }
}

function showBaStyleDesign(search, $this)
{
    var parent = $g($this).closest('.tab-pane'),
        value = app.getValue(search);
    parent.find('> .ba-settings-group:not(.blog-posts-background-options):not(.blog-posts-shadow-options)').hide();
    parent.find('> .ba-settings-group:first-child').css('display', '');
    parent.find('.last-element-child').removeClass('last-element-child');
    parent.find('.ba-style-typography-color')[0].style.display = '';
    parent.find('.ba-style-typography-hover-color').hide();
    parent.find('.title-html-tag').hide();
    if (search == 'title') {
        parent.find('.title-html-tag').css('display', '');
    }
    switch (search) {
        case 'image' :
            parent.find('.ba-style-'+search+'-options').css('display', '');
            if (app.edit.type != 'blog-posts') {
                parent.find('.ba-style-border-options').show()
                    .find('input[data-subgroup]').attr('data-group', search);
            }
            break;
        case 'pagination' :
            parent.find('.ba-style-'+search+'-options').css('display', '');
            break;
        case 'button' :
            parent.find('.ba-style-typography-color').hide();
            parent.find('.ba-style-typography-options').show().find('[data-subgroup="typography"]').attr('data-group', search);
            parent.find('.ba-style-margin-options').show().find('[data-subgroup]').attr('data-group', search);
            parent.find('.ba-style-margin-options [data-type="reset"][data-subgroup="margin"]').attr('data-option', search);
            parent.find('.ba-style-'+search+'-options').show().find('input[data-subgroup]').attr('data-group', search);
            parent.find('.ba-style-border-options').show()
                .find('input[data-subgroup]').attr('data-group', search);
            parent.find('.ba-style-typography-options .typography-options').addClass('ba-active-options');
            setTimeout(function(){
                parent.find('.ba-style-typography-options .typography-options').removeClass('ba-active-options');
            }, 1);
            break;
        case 'intro' :
            if (app.edit.type != 'author') {
                parent.find('.ba-style-'+search+'-options').css('display', '');
            }
        default:
            parent.find('.ba-style-typography-options').show().find('[data-subgroup="typography"]').attr('data-group', search);
            parent.find('.ba-style-margin-options').show().find('[data-subgroup]').attr('data-group', search);
            parent.find('.ba-style-margin-options [data-type="reset"][data-subgroup="margin"]')
                .attr('data-option', search);
            parent.find('.ba-style-typography-options .typography-options').addClass('ba-active-options');
            setTimeout(function(){
                parent.find('.ba-style-typography-options .typography-options').removeClass('ba-active-options');
            }, 1);
            break;
    }
    if (app.edit.layout && app.edit.layout.layout == 'ba-cover-layout') {
        $g('#recent-posts-design-options .ba-style-image-options').first().find('.ba-settings-item').first().hide();
        $g('#blog-posts-design-options .ba-style-image-options').first().find('.ba-settings-item').first().hide();
    } else {
        $g('#recent-posts-design-options .ba-style-image-options').first().find('.ba-settings-item').first().css('display', '');
        $g('#blog-posts-design-options .ba-style-image-options').first().find('.ba-settings-item').first().css('display', '');
        $g('.blog-posts-cover-options').hide();
    }
    if (value.typography) {
        app.setTypography(parent.find('.ba-style-typography-options .typography-options'), search, 'typography');
        parent.find('.ba-style-typography-hover-color').hide();
    }
    if (search == 'title' || search == 'info') {
        parent.find('.ba-style-typography-hover-color input[data-option="color"]').attr('data-group', search);
        parent.find('.ba-style-typography-hover-color').css('display', '');
    }
    for (var ind in value) {
        if (typeof(value[ind]) == 'object') {
            if (ind != 'typography') {
                for (var key in value[ind]) {
                    var input = parent.find('[data-group="'+search+'"][data-option="'+key+'"][data-subgroup="'+ind+'"]');
                    if (input.attr('data-type') == 'color') {
                        updateInput(input, value[ind][key]);
                    } else if (input.attr('type') == 'number') {
                        var range = input.prev();
                        input.val(value[ind][key]);
                        range.val(value[ind][key]);
                        setLinearWidth(range);
                    } else  {
                        input.val(value[ind][key]);
                        if (input.attr('type') == 'hidden') {
                            var text = input.closest('.ba-custom-select').find('li[data-value="'+value[ind][key]+'"]').text();
                            input.closest('.ba-custom-select').find('input[readonly]').val($g.trim(text));
                        }
                    }
                }
            }
        } else {
            var input = parent.find('[data-group="'+search+'"][data-option="'+ind+'"]');
            if (input.attr('data-type') == 'color') {
                updateInput(input, value[ind]);
            } else if (input.attr('type') == 'number') {
                var range = input.prev();
                input.val(value[ind]);
                range.val(value[ind]);
                setLinearWidth(range);
            } else if (input.attr('type') == 'hidden') {
                input.val(value[ind]);
                var name = input.closest('.ba-custom-select').find('li[data-value="'+value[ind]+'"]').text();
                input.closest('.ba-custom-select').find('input[readonly]').val($g.trim(name));
            }
        }
    }
}

function createVideo(selector)
{
    var obj = {
        callback : 'createVideo',
        selector : selector,
        data : app.edit.desktop.video
    }
    if (app.edit.type == 'flipbox') {
        obj.selector = '#'+app.editor.$g(selector+' .ba-flipbox-'+app.edit.side+' > .ba-grid-column-wrapper > .ba-grid-column').attr('id');
        obj.data = app.edit.sides[app.edit.side].desktop.video;
    }
    app.editor.app.listenMessage(obj);
}

function setShapeDividers(obj, id)
{
    app.editor.$g('#'+id+' > .ba-shape-divider').remove();
    var divider = document.createElement('div'),
        dividerBottom = document.createElement('div'),
        topKeys = new Array(),
        bottomKeys = new Array();
    if (obj.desktop.shape.bottom.effect) {
        bottomKeys.push(obj.desktop.shape.bottom.effect);
    }
    if (obj.desktop.shape.top.effect) {
        topKeys.push(obj.desktop.shape.top.effect);
    }
    for (var key in app.editor.breakpoints) {
        if (obj[key] && obj[key].shape) {
            if (obj[key].shape.bottom && obj[key].shape.bottom.effect) {
                bottomKeys.push(obj[key].shape.bottom.effect)
            }
            if (obj[key].shape.top && obj[key].shape.top.effect) {
                topKeys.push(obj[key].shape.top.effect)
            }
        }
    }
    if (bottomKeys.length > 0) {
        var str = '';
        for (var i = 0; i < bottomKeys.length; i++) {
            str += shapeDividers[bottomKeys[i]] ? shapeDividers[bottomKeys[i]] : '';
        }
        dividerBottom.className = 'ba-shape-divider ba-shape-divider-bottom';
        dividerBottom.innerHTML = str;
        app.editor.$g('#'+id+' > .ba-overlay').after(dividerBottom);
    }
    if (topKeys.length > 0) {
        var str = '';
        for (var i = 0; i < topKeys.length; i++) {
            str += shapeDividers[topKeys[i]] ? shapeDividers[topKeys[i]] : '';
        }
        divider.className = 'ba-shape-divider ba-shape-divider-top';
        divider.innerHTML = str;
        app.editor.$g('#'+id+' > .ba-overlay').after(divider);
    }
}

function rangeAction(range, callback)
{
    var $this = $g(range),
        max = $this.attr('max') * 1,
        min = $this.attr('min') * 1,
        number = $this.next();
    number.on('input', function(){
        var value = this.value * 1;
        if (max && value > max) {
            this.value = value = max;
        }
        if (min && value < min) {
            value = min;
        }
        $this.val(value);
        setLinearWidth($this);
        callback(number);
    });
    $this.on('input', function(){
        var value = this.value * 1;
        number.val(value).trigger('input');
    });
}

function setLinearWidth(range)
{
    var max = range.attr('max') * 1,
        value = range.val() * 1,
        sx = ((Math.abs(value) * 100) / max) * range.width() / 100,
        linear = range.prev();
    if (value < 0) {
        linear.addClass('ba-mirror-liner');
    } else {
        linear.removeClass('ba-mirror-liner');
    }
    if (linear.hasClass('letter-spacing')) {
        sx = sx / 2;
    }
    linear.width(sx);
}

function videoDelay(selector)
{
    clearTimeout(delay);
    if (app.edit.desktop.video.id || app.edit.desktop.video.source) {
        delay = setTimeout(function(){
            createVideo(selector);
            app.addHistory();
        }, 300);
    }
}

app.setValue = function(value, group, option, type){
    if (typeof(app.edit.desktop[group]) == 'undefined' && group != 'span') {
        if (type) {
            app.edit[group][type][option] = value;
        } else {
            if (option) {
                app.edit[group][option] = value;
            } else {
                app.edit[group] = value;
            }
        }
    } else {
        if (!app.edit[app.view][group]) {
            app.edit[app.view][group] = {};
        }
        if (type) {
            if (!app.edit[app.view][group][type]) {
                app.edit[app.view][group][type] = {};
            }
            app.edit[app.view][group][type][option] = value;
        } else {
            if (option) {
                app.edit[app.view][group][option] = value;
            } else {
                app.edit[app.view][group] = value;
            }
        }
    }
}

function getSlideHtml(obj)
{
    var li = document.createElement('li'),
        caption = document.createElement('div'),
        inner = document.createElement('div'),
        str = '<div class="slideshow-title-wrapper',
        img = document.createElement('div');
    li.className = 'item';
    img.className = 'ba-slideshow-img';
    if (app.edit.type == 'slideshow') {
        if (obj.video) {
            img.dataset.video = true;
        }
        var video = document.createElement('div');
        video.id = new Date().getTime() + Math.floor(Math.random() * 100);
        img.appendChild(video);
        li.appendChild(img);
        li.appendChild(caption);
        var animation = {
            title : app.edit.desktop.title.animation.effect,
            description : app.edit.desktop.description.animation.effect,
            button : app.edit.desktop.button.animation.effect,
        }
    } else {
        inner.className = 'slideset-inner';
        li.appendChild(inner);
        inner.appendChild(img);
        inner.appendChild(caption);
        var animation = {
            title : '',
            description : '',
            button : ''
        }
    }
    caption.className = 'ba-slideshow-caption';
    if (!obj.title) {
        str += ' empty-content';
    }
    str += '"><'+app.edit.tag+' class="ba-slideshow-title '+animation.title+'">';
    str += obj.title+'</'+app.edit.tag+'></div><div class="slideshow-description-wrapper';
    if (!obj.description) {
        str += ' empty-content';
    }
    str += '"><div class="ba-slideshow-description '+animation.description;
    str += '">'+obj.description+'</div></div><div class="slideshow-button';
    if (!obj.button.title) {
        str += ' empty-content';
    }
    str += '"><a class="'+obj.button.type+" ";
    str += animation.button+'" href="'+obj.button.href;
    str += '" target="'+obj.button.target+'"';
    if (obj.button.download) {
        str += ' download';
    }
    str += '>'+obj.button.title+'</a></div>';
    caption.innerHTML = str;

    return li
}

function getTextTypographyValue(group, option, type)
{
    var obj = app.editor.$g(app.selector).closest('footer.footer').length > 0 ? app.editor.app.footer : app.editor.app.theme,
        object = $g.extend(true, {}, obj.desktop);
    if (app.view != 'desktop') {
        for (var ind in app.editor.breakpoints) {
            if (!obj[ind]) {
                obj[ind] = {};
            }
            object = $g.extend(true, {}, object, obj[ind]);
            if (ind == app.view) {
                break;
            }
        }
    }
    if (type) {
        return object[group][type][option];
    } else if (option) {
        return object[group][option];
    } else {
        return object[group];
    }
}

app.getValue = function(group, option, type){
    var object = $g.extend(true, {}, app.edit.desktop);
    if (app.view != 'desktop') {
        for (var ind in app.editor.breakpoints) {
            if (!app.edit[ind]) {
                app.edit[ind] = {};
            }
            object = $g.extend(true, {}, object, app.edit[ind]);
            if (ind == app.view) {
                break;
            }
        }
    }
    if (!object[group]) {
        return false;
    } else if (type) {
        return object[group][type][option];
    } else if (option) {
        return object[group][option];
    } else {
        return object[group];
    }
}

function inputCallback(input)
{
    var val = input.val(),
        module = input.attr('data-module'),
        option = input.attr('data-option'),
        callback = input.attr('data-callback'),
        subgroup = input.attr('data-subgroup'),
        group = input.attr('data-group');
    if (!group) {
        group = option;
        option = '';
    }
    if (group || option || subgroup) {
        app.setValue(val, group, option, subgroup);
        clearTimeout(delay)
        delay = setTimeout(function(){
            app[callback]();
            if (app.edit.type == 'slideset' || app.edit.type == 'carousel' || app.edit.type == 'recent-posts-slider') {
                var object = {
                    data : app.edit,
                    selector : app.editor.app.edit
                };
                app.editor.app.checkModule('initslideset', object);
            } else if (app.edit.type == 'progress-pie') {
                app.drawPieLine();
            }
            app.addHistory();
            if (module) {
                app.editor.app.checkModule(module);
            }
        }, 300);
    } else {
        app[callback]();
    }
    if (app.edit && (app.edit.type == 'text' || app.edit.type == 'headline') && group != 'margin') {
        input.closest('.ba-settings-item').find('> div:last-child').css('display', '');
    }
}

function linkAction(query, $this)
{
    var img = app.editor.document.getElementById(app.editor.app.edit);
    img = img.querySelector(query);
    if (img.parentNode.localName == 'a') {
        if ($g.trim($this.value)) {
            img.parentNode.href = $this.value;
        } else {
            var a = img.parentNode;
            a.parentNode.insertBefore(img, a);
            a.parentNode.removeChild(a);
        }
    } else {
        if ($g.trim($this.value)) {
            var a = document.createElement('a');
            a.href = $this.value;
            a.target = app.edit.link.target;
            if (app.edit.link.type) {
                a.setAttribute('download', '');
            } else {
                a.removeAttribute('download');
            }
            img.parentNode.insertBefore(a, img);
            a.appendChild(img);
            a.addEventListener('click', function(event){
                event.preventDefault();
            });
            var html = a.innerHTML,
                str = '<a class="ba-btn-transition" target="'+app.edit.link.target+'"';
            str += ' href="'+$this.value+'"';
            if (app.edit.link.type) {
                str += ' download';
            }
            str += ' '+app.edit.embed;
            str += '></a>';
            var div = document.createElement(div);
            div.innerHTML = str;
            if (div.querySelector('a')) {
                div.querySelector('a').innerHTML = html;
                $g(a).replaceWith(div.querySelector('a'));
            }
        }
    }
    app.edit.link.link = $this.value;
}

function setMinicolorsColor(value)
{
    var rgba = app.editor.app.theme.colorVariables[value] ? app.editor.app.theme.colorVariables[value].color : value,
        color = rgba2hex(rgba);
    var obj = {
        color : color[0],
        opacity : color[1],
        update: false
    }
    $g('.variables-color-picker').minicolors('value', obj).closest('#color-picker-cell')
        .find('.minicolors-opacity').val(color[1]);
    $g('#color-variables-dialog .active').removeClass('active');
    $g('#color-picker-cell, #color-variables-dialog .nav-tabs li:first-child').addClass('active');
}

function inputColor()
{
    var value = this.value.trim().toLowerCase();
    if (value.indexOf('@') === 0) {
        $g(this).closest('.ba-settings-item').find('.minicolors-opacity').val('').attr('readonly', true);
        if (app.editor.app.theme.colorVariables[value]) {
            this.dataset.rgba = value;
            var color = app.editor.app.theme.colorVariables[value].color
            $g(this).next().find('.minicolors-swatch-color').css('background-color', color);
            setMinicolorsColor(value);
            $g(this).trigger('minicolorsInput');
        }
    } else {
        var parts = value.match(/[^#]\w/g),
            opacity = 1;
        if (parts && parts.length == 3) {
            var rgba = 'rgba(';
            for (var i = 0; i < 3; i++) {
                rgba += parseInt(parts[i], 16);
                rgba += ', ';
            }
            if (!this.dataset.rgba || this.dataset.rgba.indexOf('@') === 0) {
                rgba += '1)';
            } else {
                parts = this.dataset.rgba.toLowerCase().match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/);
                if (!parts) {
                    rgba += '1)';
                } else {
                    opacity = parts[4];
                    rgba += parts[4]+')';
                }
            }
            this.dataset.rgba = rgba;
            $g(this).next().find('.minicolors-swatch-color').css('background-color', rgba);
            $g(this).trigger('minicolorsInput');
            setMinicolorsColor(rgba);
        }
        $g(this).closest('.ba-settings-item').find('.minicolors-opacity').val(opacity).removeAttr('readonly');
    }
}

$g('input[data-type="color"]').each(function(){
    var div = document.createElement('div'),
        callback = $g(this).parent().find('.minicolors-opacity').attr('data-callback');
    div.className = 'minicolors minicolors-theme-bootstrap';
    this.dataset.callback = callback;
    this.classList.add('minicolors-input');
    $g(this).wrap(div);
    $g(this).after('<span class="minicolors-swatch"><span class="minicolors-swatch-color"></span></span>');
});

$g('.ba-range-wrapper input[type="range"]').each(function(){
    rangeAction(this, inputCallback);
});

$g('.ba-settings-toolbar input[type="number"]').on('input', function(){
    inputCallback($g(this));
});

$g('[data-type="upload-image"]').on('mousedown', function(){
    fontBtn = this;
    var modal = $g('#uploader-modal').attr('data-check', 'single');
    uploadMode = 'image';
    checkIframe(modal, 'uploader');
});

$g('.border-style-select').on('customAction', function(){
    var $this = $g(this).find('input[type="hidden"]'),
        val = $this.val(),
        subgroup = $this.attr('data-subgroup'),
        group = $this.attr('data-group'),
        option = $this.attr('data-option');
    app.setValue(val, group, option, subgroup);
    app.sectionRules();
    app.addHistory();
});

$g('.image-options .ba-custom-select').on('customAction', function(){
    var option = $g(this).find('input[type="hidden"]')[0];
    app.setValue(option.value, 'background', option.dataset.option, 'image');
    app[option.dataset.action]();
    app.addHistory();
});

$g('.video-select').on('customAction', function(){
    var type = $g(this).find('[data-option="video-type"]').val(),
        value = $g(this).find('li[data-value="'+type+'"]').text().trim(),
        parent = $g(this).closest('.video-options');
    parent.addClass('ba-active-options');
    parent.find('.video-source-select, .youtube-quality').hide();
    parent.find('.video-id').css('display', '');
    if (type == 'youtube') {
        parent.find('.youtube-quality').show();
    } else if (type == 'source') {
        parent.find('.video-id').hide();
        parent.find('.video-source-select').css('display', '');
    }
    $g(this).find('input[readonly]').val(value);
    setTimeout(function(){
        parent.removeClass('ba-active-options');
    }, 1);
});

$g('.video-source-select input').on('click', function(){
    fontBtn = this;
    uploadMode = 'videoSource';
    checkIframe($g('#uploader-modal').attr('data-check', 'single'), 'uploader');
}).on('change', function(){
    if (this.dataset.option) {
        var option = this.dataset.option,
            type = $g(this).closest('.video-options').find('[data-option="video-type"]').val();
        app.edit.desktop.video.type = type;
        app.edit.desktop.video[option] = this.value;
        app.edit.desktop.video['id'] = '';
        $g(this).closest('.ba-settings-group').find('[data-option="id"]').val('');
        videoDelay(app.selector);
    } else {
        $g('#apply-new-slide').removeClass('disable-button').addClass('active-button');
    }
});

$g('.video-options [data-option="id"], .video-options [data-option="start"]').on('input', function(){
    var option = this.dataset.option,
        type = $g(this).closest('.video-options').find('[data-option="video-type"]').val();
    app.edit.desktop.video.type = type;
    app.edit.desktop.video[option] = this.value;
    if (option == 'id') {
        app.edit.desktop.type = 'video';
        app.edit.desktop.video['source'] = '';
        $g(this).closest('.ba-settings-group').find('[data-option="source"]').val('');
    }
    videoDelay(app.selector);
});

$g('.video-options [data-option="mute"]').on('change', function(){
    var type = $g(this).closest('.video-options').find('[data-option="video-type"]').val();
    app.edit.desktop.video.type = type;
    if (app.edit.desktop.video.mute) {
        app.edit.desktop.video.mute = 0;
    } else {
        app.edit.desktop.video.mute = 1;
    }
    videoDelay(app.selector);
});

$g('.video-quality').on('customAction', function(){
    var quality = $g(this).find('input[type="hidden"]').val(),
        type = $g(this).closest('.video-options').find('[data-option="video-type"]').val();
    app.edit.desktop.video.type = type;
    app.edit.desktop.video.quality = quality;
    videoDelay(app.selector);
});

function backgroundSelectAction($this, callback)
{
    var target = $this.find('input[type="hidden"]').val(),
        parent = $g('.'+target+'-options');
    app.setValue(target, 'background', 'type');
    app[callback]();
    $this.closest('.ba-settings-group').find('.background-options').find('> div').hide();
    parent.css('display', '').addClass('ba-active-options');
    if (typeof(app.editor.videoResize) != 'undefined') {
        app.editor.videoResize();
    }
    setTimeout(function(){
        parent.removeClass('ba-active-options');
    }, 1);
}

$g('.background-select').on('customAction', function(){
    var $this = $g(this);
    app.setValue('', 'video', 'id');
    app.setValue('', 'video', 'source');
    app.setValue('', 'background', 'image', 'image');
    if (app.edit.parallax) {
        app.edit.parallax.enable = false;
        $g('[data-group="parallax"][data-option="enable"]').prop('checked', app.edit.parallax.enable);
        app.editor.app.loadParallax();
        $g('.parallax-options').css('display', 'none');
    }
    backgroundSelectAction($this, this.dataset.callback);
    $this.closest('.ba-settings-group').find('[data-type="upload-image"], [data-option="id"], [data-option="source"]').val('');
    app.addHistory();
});

$g('.backround-size').on('customAction', function(){
    var size = $g(this).find('input[type="hidden"]').val(),
        parent = $g(this).closest('.tab-pane').find('.contain-size-options');
    if (size == 'contain' || size == 'initial') {
        parent.show().addClass('ba-active-options');
    } else {
        parent.hide();
    }
    setTimeout(function(){
        parent.removeClass('ba-active-options');
    }, 1);
});

$g('[data-type="reset"]').not('.reset-text-typography').on('mousedown', function(){
    var option = this.dataset.option,
        action = this.dataset.action,
        subgroup = this.dataset.subgroup,
        search = '[data-group="'+option+'"]',
        parent = $g(this).closest('.ba-settings-toolbar');
    if (subgroup) {
        search += '[data-subgroup="'+subgroup+'"]';
    }
    parent.find(search).not(this).each(function(){
        var key = this.dataset.option;
        this.value = 0;
        app.setValue('0', option, key, subgroup);
    });
    app[action]();
    app.addHistory();
});

$g('.reset-text-typography').on('mousedown', function(){
    var input = $g(this).closest('.ba-settings-item').find('input[type="number"]'),
        group = input.attr('data-group'),
        option = input.attr('data-option'),
        val = getTextTypographyValue(group, option);
    var range = input.val(val).prev().val(val);
    setLinearWidth(range);
    delete(app.edit[app.view][group][option]);
    app.sectionRules();
    app.addHistory();
    $g(this).closest('div').hide();
});

$g('input[data-option="disable"]').on('change', function(){
    var val = Number(this.checked);
    if ((app.edit.type == 'lightbox' || app.edit.type == 'cookies') && this.dataset.group == app.view) {
        var item = app.editor.document.querySelector('.ba-lightbox-backdrop[data-id="'+app.editor.app.edit+'"]');
        if (val == 1 && $g('.show-hidden-elements')[0].style.display != 'none') {
            item.classList.remove('visible-lightbox');
            app.editor.document.body.classList.remove('lightbox-open');
            app.editor.document.body.classList.remove('ba-lightbox-open');
        } else {
            item.classList.add('visible-lightbox');
            app.editor.document.body.classList.remove('ba-lightbox-open');
            if (app.edit.position == 'lightbox-center') {
                app.editor.document.body.classList.add('lightbox-open');
            }
        }
    }
    if (app.edit.type == 'overlay-section' && this.dataset.group == app.view) {
        var item = app.editor.document.querySelector('.ba-overlay-section-backdrop[data-id="'+app.editor.app.edit+'"]');
        if (val == 1 && $g('.show-hidden-elements')[0].style.display != 'none') {
            item.classList.remove('visible-section');
            app.editor.document.body.classList.remove('lightbox-open');
        } else {
            item.classList.add('visible-section');
            app.editor.document.body.classList.add('lightbox-open');
        }
    }
    if (app.edit.type == 'column') {
        var item = app.editor.document.getElementById(app.editor.app.edit).parentNode,
            className = '';
        switch (this.dataset.group) {
            case 'tablet':
                className = 'md';
                break;
            case 'phone' : 
                className = 'sm';
                break;
            default : 
                className = 'lg';
        }
        if (val == 0) {
            item.classList.remove('ba-hidden-'+className);
            if (this.dataset.group == 'desktop' && item.parentNode.lastElementChild == item) {
                item.previousElementSibling.classList.remove('ba-hidden-node');
            }
        } else {
            item.classList.add('ba-hidden-'+className);
            if (this.dataset.group == 'desktop' && item.parentNode.lastElementChild == item) {
                item.previousElementSibling.classList.add('ba-hidden-node');
            }
        }
    }
    app.edit[this.dataset.group].disable = val;
    app.sectionRules();
    app.addHistory();
});

$g('.section-access-select').on('customAction', function(){
    var val = $g(this).find('input[type="hidden"]').val();
    app.edit.access = val;
    app.addHistory();
});

$g('.class-suffix').on('input', function(){
    var id = app.editor.app.edit,
        val = this.value;
    editClass(val, id, app.edit);
});

$g('.typography-select').on('customAction', function(){
    var target = $g(this).find('input[type="hidden"]').val(),
        parent = $g(this).closest('.ba-settings-group').find('.typography-options');
    parent.find('> div').hide();
    if (target == 'links') {
        parent.find('.links').removeAttr('style');
    } else {
        parent.find('> div').not('.links').removeAttr('style')
    }
    app.setTypography(parent, target);
    parent.addClass('ba-active-options');
    setTimeout(function(){
        parent.removeClass('ba-active-options');
    }, 1);
});

$g('label[data-option]').on('click', function(){
    var val = this.dataset.value,
        option = this.dataset.option,
        group = this.dataset.group,
        subgroup = this.dataset.subgroup,
        callback = this.dataset.callback;
    switch (option) {
        case 'text-align' :
        case 'open-align' :
        case 'close-align' :
        case 'align' :
            if (!$g(this).hasClass('active')) {
                var label = $g(this).closest('.ba-settings-toolbar').find('label[data-option="'+option+'"].active');
                if (!group) {
                    group = option;
                    option = '';
                }
                app.setValue(val, group, option, subgroup);
                label.removeClass('active');
                app[callback]();
                $g(this).addClass('active');
                app.addHistory();
            }
            break;
        case 'font-style' :
            if ($g(this).hasClass('active')) {
                app.setValue('normal', group, option, subgroup);
                $g(this).removeClass('active');
            } else {
                app.setValue(val, group, option, subgroup);
                $g(this).addClass('active');
            }
            app[callback]();
            app.addHistory();
            break;
        default :
            if ($g(this).hasClass('active')) {
                app.setValue('none', group, option, subgroup);
                $g(this).removeClass('active');
            } else {
                app.setValue(val, group, option, subgroup);
                $g(this).addClass('active');
            }
            app[callback]();
            app.addHistory();
    }
});

$g('#color-variables-dialog .minicolors-opacity').on('input', function(){
    var obj = {
        color: $g('.variables-color-picker').val(),
        opacity: this.value * 1,
        update: false
    }
    $g('.variables-color-picker').minicolors('value', obj);
    fontBtn.dataset.rgba = $g('.variables-color-picker').minicolors('rgbaString');
    $g(fontBtn).trigger('minicolorsInput');
    if (fontBtn.localName == 'input') {
        $g(fontBtn).next().find('.minicolors-swatch-color').css('background-color', fontBtn.dataset.rgba)
            .closest('.minicolors').next().find('.minicolors-opacity').val(this.value);
    }
});

$g('.minicolors-opacity[data-callback]').on('input', function(){
    var input = $g(this).parent().prev().find('.minicolors-input')[0],
        opacity = this.value * 1
        value = input.dataset.rgba;
    if (value.indexOf('@') === -1 && this.value) {
        var parts = value.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/),
            rgba = 'rgba(';
        if (parts) {
            for (var i = 1; i < 4; i++) {
                rgba += parts[i]+', ';
            }
        } else {
            parts = value.match(/[^#]\w/g);
            for (var i = 0; i < 3; i++) {
                rgba += parseInt(parts[i], 16);
                rgba += ', ';
            }
        }
        rgba += this.value+')';
        input.dataset.rgba = rgba;
        $g(input).next().find('.minicolors-swatch-color').css('background-color', rgba);
        $g(input).trigger('minicolorsInput');
    }
});

$g('input[data-type="color"]').on('click', function(){
    fontBtn = this;
    setMinicolorsColor(this.dataset.rgba);
    var rect = this.getBoundingClientRect();
    $g('#color-variables-dialog').css({
        left : rect.left - 285,
        top : rect.bottom - ((rect.bottom - rect.top) / 2) - 174
    }).removeClass('ba-right-position').modal().find('.nav-tabs li:last').css('display', '');
}).on('minicolorsInput', function(){
    var $this = this,
        rgba = this.dataset.rgba,
        option = this.dataset.option,
        subgroup = this.dataset.subgroup,
        group = this.dataset.group;
    if (!group) {
        group = option;
        option = '';
    }
    app.setValue(rgba, group, option, subgroup);
    clearTimeout(this.minicolorsDelay);
    this.minicolorsDelay = setTimeout(function(){
        app[$this.dataset.callback]();
        if (app.edit.type == 'progress-pie' && (option == 'bar' || option == 'background')) {
            app.drawPieLine();
        }
    }, 300);
}).on('input', inputColor).next().on('click', function(){
    $g(this).prev().trigger('click');
});

$g('.show-text-editor-general').on('click', function(event){
    event.preventDefault();
    var parent = $g(this).closest('.general-tabs'),
        show = $g.Event('show', {
        relatedTarget : parent.find('li.active a')[0],
        target : this
    });
    parent.find('.hide-general-cell').removeClass('hide-general-cell').addClass('show-general-cell');
    parent.find('li.active').removeClass('active');
    $g(this).trigger(show).trigger('shown').parent().addClass('active');
});

$g('.hide-text-editor-general').on('click', function(event){
    event.preventDefault();
    var parent = $g(this).closest('.general-tabs'),
        show = $g.Event('show', {
        relatedTarget : parent.find('li.active a')[0],
        target : this
    });
    parent.find('.show-general-cell').removeClass('show-general-cell').addClass('hide-general-cell');
    if (!this.dataset.toggle) {
        parent.find('li.active').removeClass('active');
        $g(this).trigger(show).parent().addClass('active');
    }
});

$g('.link-target-select').on('customAction', function(){
    app.edit.link.target = $g(this).find('input[type="hidden"]').val();
    var a = app.editor.document.getElementById(app.editor.app.edit);
    a = a.querySelector('a');
    if (a) {
        a.target = app.edit.link.target;
    }
    app.addHistory();
});

$g('.media-fullscrean').on('click', function(){
    var modal = $g(this).closest('.modal');
    if (!modal.hasClass('fullscrean')) {
        modal.addClass('fullscrean');
        $g(this).removeClass('zmdi-fullscreen').addClass('zmdi-fullscreen-exit');
    } else {
        modal.removeClass('fullscrean');
        $g(this).addClass('zmdi-fullscreen').removeClass('zmdi-fullscreen-exit');
    }        
});

$g('.reset:not(.disabled-reset) i').on('click', function(){
    var option = this.dataset.option,
        callback = this.dataset.callback,
        group  = this.dataset.group;
    $g('input[data-option="'+option+'"][data-group="'+group+'"]').val('');
    app.setValue('', group, option);
    window[callback]();
    app.addHistory();
});

$g('[data-option="link"][data-group="link"]').on('input', function(){
    var $this = this;
    clearTimeout(delay);
    delay = setTimeout(function(){
        switch (app.edit.type) {
            case 'icon' :
                linkAction('.ba-icon-wrapper i', $this);
                break
            case 'image' :
                linkAction('img', $this);
                break;
            default :
                var a = app.editor.document.getElementById(app.editor.app.edit);
                a = a.querySelector('a');
                a.href = $this.value;
                app.edit.link.link = $this.value;
        }
        app.addHistory();
    }, 300);
});

$g('[data-option="type"][data-group="link"]').on('change', function(){
    var a = app.editor.document.querySelector(app.selector+' a');
    app.edit.link.type = this.value;
    if (a) {
        if (app.edit.link.type) {
            a.setAttribute('download', '');
        } else {
            a.removeAttribute('download');
        }
    }
});

$g('input[data-option="alt"]').on('input', function(){
    clearTimeout(delay);
    var $this = this,
        img = app.editor.document.getElementById(app.editor.app.edit);
    img = img.querySelector('img');
    delay = setTimeout(function(){
        app.edit.alt = $this.value;
        img.alt = $this.value;
        app.addHistory();
    }, 300);
});

$g('input[data-option="image"].reselect-image').on('mousedown', function(){
    fontBtn = this;
    uploadMode = 'reselectImage';
    checkIframe($g('#uploader-modal').attr('data-check', 'single'), 'uploader');
});

$g('input[type="checkbox"][data-group="border"]').on('change', function(){
    var val = 0,
        option = this.dataset.option,
        subgroup = this.dataset.subgroup,
        group = this.dataset.group;
    if (this.checked) {
        val = 1;
    }
    app.setValue(val, group, option, subgroup);
    app.sectionRules();
    app.addHistory();
});

$g('.set-value-css').on('change input', function(){
    var $this = this,
        time = 300;
    if (this.type == 'checkbox') {
        time = 0;
    }
    clearTimeout(delay);
    delay = setTimeout(function(){
        var option = $this.dataset.option,
            value = $this.value,
            subgroup = $this.dataset.subgroup,
            group = $this.dataset.group;
        if (!group) {
            group = option;
            option = '';
        }
        if ($this.type == 'checkbox') {
            value = $this.checked;
        }
        app.setValue(value, group, option, subgroup);
        app.sectionRules();
        app.addHistory();
        if (app.edit.type == 'slideset' || app.edit.type == 'carousel' || app.edit.type == 'recent-posts-slider') {
            var object = {
                data : app.edit,
                selector : app.editor.app.edit
            };
            app.editor.app.checkModule('initslideset', object);
        } else if (app.edit.type == 'slideshow' && group == 'thumbnails' && option == 'count') {
            var object = {
                data : app.edit,
                selector : app.editor.app.edit
            };
            app.editor.app.checkModule('initslideshow', object);
        }
    }, time);
});

$g('.ba-style-custom-select').on('customAction', function(){
    var value = $g(this).find('input[type="hidden"]').val();
    showBaStyleDesign(value, this);
});

$g('.blog-posts-layout-select').on('customAction', function(){
    var value = $g(this).find('input[type="hidden"]').val();
    app.editor.$g(app.selector+' > div[class*="-wrapper"]').removeClass(app.edit.layout.layout);
    app.edit.layout.layout = value;
    app.editor.$g(app.selector+' > div[class*="-wrapper"]').addClass(app.edit.layout.layout);
    $g('.blog-posts-cover-options').hide();
    $g('.blog-posts-background-options').css('display', '');
    $g('#recent-posts-design-options .ba-style-image-options').first().find('.ba-settings-item').first().css('display', '');
    $g('#blog-posts-design-options .ba-style-image-options').first().find('.ba-settings-item').first().css('display', '');
    if (app.edit.layout.layout == 'ba-classic-layout' || app.edit.layout.layout == 'ba-one-column-grid-layout') {
        $g('.blog-posts-grid-options').hide();
        $g('.blog-posts-grid-options input[data-option="count"]').closest('.ba-settings-group');
        if (app.edit.type != 'blog-posts') {
            $g('#recent-posts-design-options .ba-style-image-options').first().css('display', '');
        }
    } else {
        $g('.blog-posts-grid-options').css('display', '');
        $g('.blog-posts-grid-options input[data-option="count"]').closest('.ba-settings-group');
        if (app.edit.layout.layout == 'ba-cover-layout') {
            $g('.ba-style-image-options .blog-posts-grid-options').hide();
            $g('.blog-posts-cover-options').css('display', '');
            $g('.blog-posts-background-options').hide();
            $g('#recent-posts-design-options .ba-style-image-options').first().find('.ba-settings-item').first().hide();
            $g('#blog-posts-design-options .ba-style-image-options').first().find('.ba-settings-item').first().hide();
        }
    }
    if (!app.edit.preset && !app.editor.app.theme.defaultPresets[app.edit.type]) {
        var type = app.edit.type,
            patern = $g.extend(true, {}, presetsPatern[type]),
            is_object = null,
            object = defaultElementsStyle[type];
        for (var ind in patern) {
            if (ind == 'desktop') {
                for (var key in patern[ind]) {
                    is_object = typeof(app.edit[ind][key]) == 'object';
                    app.edit[ind][key] = is_object ? $g.extend(true, {}, object[ind][key]) : object[ind][key];
                }
                for (var ind in app.editor.breakpoints) {
                    if (app.edit[ind]) {
                        for (var key in patern.desktop) {
                            is_object = typeof(app.edit[ind][key]) == 'object';
                            if (is_object && object[ind] && object[ind][key]) {
                                app.edit[ind][key] = $g.extend(true, {}, object[ind][key]);
                            } else if (!is_object && object[ind] && object[ind][key]) {
                                app.edit[ind][key] = object[ind][key];
                            } else if (is_object) {
                                app.edit[ind][key] = {};
                            } else {
                                delete(app.edit[ind][key]);
                            }
                        }
                    }
                }
            } else {
                is_object = typeof(app.edit[ind]) == 'object';
                app.edit[ind] = is_object ? $g.extend(true, {}, object[ind]) : object[ind];
            }
        }
        switch(app.edit.type){
            case 'author':
                if (app.edit.layout.layout == 'ba-grid-layout') {
                    app.edit.desktop.view.count = 1;
                    app.edit.desktop.title.typography['text-align'] = 'center';
                    app.edit.desktop.intro.typography['text-align'] = 'center';
                }
                break;
            case 'blog-posts':
            case 'search-result':
                var view = {
                    "date":true,
                    "category":true,
                    "author":false,
                    "image":true,
                    "title":true,
                    "intro":true,
                    "button":true,
                    "hits":false
                }
                if (app.edit.type == 'blog-posts' &&
                    (app.edit.layout.layout == 'ba-one-column-grid-layout' || app.edit.layout.layout == 'ba-classic-layout')) {
                    view.author = true;
                }
                if (app.edit.type == 'search-result') {
                    view.category = view.intro = view.button = view.hits = false;
                }
                app.edit.desktop.view = $g.extend(true, app.edit.desktop.view, view);
                if (app.edit.layout.layout == 'ba-cover-layout') {
                    app.edit.desktop.image.height = 400;
                    if (app.edit.type == 'blog-posts') {
                        app.edit.desktop.border.radius = 9;
                    } else {
                        app.edit.desktop.image.border.radius = 9;
                    }
                    app.edit.desktop.background.color = '@bg-primary';
                    app.edit.desktop.title.typography.color = '@title-inverse';
                    app.edit.desktop.info.typography.color = '@title-inverse';
                    app.edit.desktop.intro.typography.color = '@title-inverse';
                    app.edit.desktop.overlay.color = '@overlay';
                    app.edit.desktop.title.typography['font-size'] = 24;
                    app.edit.desktop.title.typography['line-height'] = 34;
                    app.edit.desktop.title.margin.top = 200;
                    app.edit.desktop.view.count = 2;
                    if (app.edit.type == 'search-result') {
                        app.edit.desktop.view.count = 3;
                    }
                    app.edit.desktop.view.button = false;
                    app.edit.desktop.view.intro = false;
                    app.edit.desktop.view.hits = false;
                } else if (app.edit.layout.layout == 'ba-grid-layout') {
                    app.edit.desktop.view.count = 2;
                    if (app.edit.type == 'search-result') {
                        app.edit.desktop.view.count = 3;
                    }
                    app.edit.desktop.image.width = 1170;
                    app.edit.desktop.image.height = 250;
                    app.edit.desktop.title.typography['font-size'] = 20;
                    app.edit.desktop.title.typography['line-height'] = 30;
                } else if (app.edit.layout.layout == 'ba-classic-layout') {
                    app.edit.desktop.image.width = 300;
                    app.edit.desktop.image.height = 300;
                    app.edit.desktop.background.color = 'rgba(255, 255, 255, 0)';
                    app.edit.desktop.title.typography['font-size'] = 20;
                    app.edit.desktop.title.typography['line-height'] = 30;
                } else if (app.edit.layout.layout == 'ba-one-column-grid-layout') {
                    app.edit.desktop.title.typography['font-size'] = 32;
                    app.edit.desktop.title.typography['line-height'] = 42;
                    app.edit.desktop.image.width = 1170;
                    app.edit.desktop.image.height = 400;
                    app.edit.desktop.view.count = 1;
                }
                break;
            case 'recent-posts':
            case 'related-posts':
                if (app.edit.layout.layout == 'ba-classic-layout') {
                    app.edit.desktop.image.width = 100;
                    app.edit.desktop.image.height = 100;
                    app.edit.desktop.image.border.radius = 100;
                    app.edit.desktop.background.color = 'rgba(255, 255, 255, 0)';
                    app.edit.desktop.title.typography.color = '@title';
                    app.edit.desktop.info.typography.color = '@subtitle';
                    app.edit.desktop.intro.typography.color = '@text';
                    app.edit.desktop.overlay.color = 'rgba(0, 0, 0, 0.3)';
                } else if (app.edit.layout.layout == 'ba-grid-layout') {
                    app.edit.desktop.image.width = 1170;
                    app.edit.desktop.image.height = 250;
                    app.edit.desktop.image.border.radius = 0;
                    app.edit.desktop.background.color = '@bg-secondary';
                    app.edit.desktop.title.typography.color = '@title';
                    app.edit.desktop.info.typography.color = '@subtitle';
                    app.edit.desktop.intro.typography.color = '@text';
                    app.edit.desktop.overlay.color = 'rgba(0, 0, 0, 0.3)';
                } else if (app.edit.layout.layout == 'ba-cover-layout') {
                    app.edit.desktop.image.height = 400;
                    app.edit.desktop.image.border.radius = 9;
                    app.edit.desktop.background.color = '@bg-primary';
                    app.edit.desktop.title.typography.color = '@title-inverse';
                    app.edit.desktop.info.typography.color = '@title-inverse';
                    app.edit.desktop.intro.typography.color = '@title-inverse';
                    app.edit.desktop.overlay.color = '@overlay';
                    app.edit.desktop.title.typography['font-size'] = 24;
                    app.edit.desktop.title.typography['line-height'] = 34;
                    app.edit.desktop.title.margin.top = 200;
                }
                var view = {
                    "date":true,
                    "category":true,
                    "image":true,
                    "title":true,
                    "author":false,
                    "intro":false,
                    "button":false,
                    "hits":false
                }
                app.edit.desktop.view = $g.extend(true, app.edit.desktop.view, view);
                break;
        }
        app.editor.app.checkModule('editItem');
        app.editor.app.setNewFont = true;
        app.editor.app.fonts = {};
        app.editor.app.customFonts = {};
    }
    app.sectionRules();
    app.addHistory();
});

$g('.selected-categories .search-category input').on('click', function(event){
    event.stopPropagation();
    $g('.all-categories-list li[data-app="'+app.edit.app+'"]:not(.selected-category)').css('display', '');
    $g('body').one('click', function(){
        $g('.all-categories-list li').hide();
    });
});

$g('.all-categories-list li').on('click', function(){
    if (!this.classList.contains('selected-category')) {
        this.classList.add('selected-category');
        var obj = {
            title : this.textContent.trim(),
            id : this.dataset.id
        }
        var str = getCategoryHtml(obj.id, obj.title);
        app.edit.categories[obj.id] = obj;
        $g(this).closest('.tags-categories').find('.selected-categories li.search-category').before(str);
        $g('.ba-settings-item.tags-categories-list').addClass('not-empty-list');
        window[app.recentPostsCallback]();
    }
});

$g('.selected-categories').on('click', 'li.chosen-category .zmdi-close', function(){
    $g('.all-categories-list li[data-id="'+this.dataset.remove+'"]').removeClass('selected-category');
    delete(app.edit.categories[this.dataset.remove]);
    $g(this).closest('li').remove();
    if ($g('.selected-categories li:not(.search-category)').length > 0) {
        $g('.ba-settings-item.tags-categories-list').addClass('not-empty-list');
    } else {
        $g('.ba-settings-item.tags-categories-list').removeClass('not-empty-list');
    }
    window[app.recentPostsCallback]();
});

$g('.recent-posts-app-select').on('customAction', function(){
    var input = this.querySelector('input[type="hidden"]');
    if (input.value != app.edit[input.dataset.option]) {
        app.edit[input.dataset.option] = input.value;
        app.edit.categories = {};
        $g('.selected-categories li:not(.search-category)').remove();
        $g('.all-categories-list .selected-category').removeClass('selected-category');
        $g('.ba-settings-item.tags-categories-list').removeClass('not-empty-list');
        window[app.recentPostsCallback]();
    }
});

$g('.recent-posts-display-select, .related-posts-display-select').on('customAction', function(){
    var input = this.querySelector('input[type="hidden"]');
    if (input.value != app.edit[input.dataset.option]) {
        app.edit[input.dataset.option] = input.value;
        window[app.recentPostsCallback]();
    }
});

$g('.set-featured-posts').on('change', function(){
    app.edit.featured = this.checked;
    window[app.recentPostsCallback]();
});

$g('#recent-posts-settings-dialog, #slideshow-settings-dialog').find('input.recent-limit, input[data-option="maximum"]')
    .on('input', function(){
    var $this = this;
    clearTimeout(delay);
    delay = setTimeout(function(){
        app.edit[$this.dataset.option] = $this.value;
        if (app.recentPostsCallback) {
            window[app.recentPostsCallback]();
        }
    });
});

$g('.select-link').on('click', function(){
    fontBtn = $g(this).parent().find('input[type="text"]');
    app.checkModule('selectLink');
});

$g('.select-file').on('click', function(){
    fontBtn = $g(this).parent().find('input[type="text"]');
    uploadMode = 'selectFile';
    checkIframe($g('#uploader-modal').attr('data-check', 'single'), 'uploader');
});

$g('.reset-element-icon i').on('click', function(){
    var parent = $g(this).closest('.ba-modal-sm');
    $g(parent).find('.select-item-icon').attr('data-value', '').val('').trigger('input');
});

$g('.select-item-icon').on('click', function(){
    uploadMode = 'selectItemIcon';
    checkIframe($g('#icon-upload-dialog'), 'icons');
    fontBtn = this;
});

$g('.background-overlay-select').on('customAction', function(){
    var input = this.querySelector('input[type="hidden"]'),
        parent = $g('.overlay-'+input.value+'-options');
    app.setValue(input.value, input.dataset.property, 'type');
    $g('.overlay-color-options, .overlay-gradient-options').hide();
    parent.css('display', '').addClass('ba-active-options');
    setTimeout(function(){
        parent.removeClass('ba-active-options');
    }, 1);
    if (input.dataset.callback) {
        app[input.dataset.callback]();
    } else {
        app.sectionRules();
    }
    app.addHistory();
});

$g('.gradient-effect-select').on('customAction', function(){
    var input = this.querySelector('input[type="hidden"]'),
        parent = $g(this).closest('.tab-pane');
    app.setValue(input.value, input.dataset.property, 'effect', 'gradient');
    parent.find('.'+input.dataset.property+'-linear-gradient').hide();
    parent.find('.'+input.dataset.property+'-'+input.value+'-gradient').css('display', '');
    if (input.dataset.callback) {
        app[input.dataset.callback]();
    } else {
        app.sectionRules();
    }
    app.addHistory();
});

$g('.slideshow-style-custom-select').on('customAction', function(){
    var value = $g(this).find('input[type="hidden"]').val();
    showSlideshowDesign(value, this);
});

function addFontLink(obj, key)
{
    var object = app.editor.$g(app.selector).closest('footer.footer').length > 0 ? app.editor.app.footer : app.editor.app.theme,
        font = obj.font == '@default' ? getTextParentFamily(object.desktop, key) : obj.font,
        styles = obj.styles == '@default' ? getTextParentWeight(object.desktop, key) : obj.styles,
        link = '//fonts.googleapis.com/css?family='+font+':'+styles,
        file = app.editor.document.createElement('link');
    link += '&subset=latin,cyrillic,greek,latin-ext,greek-ext,vietnamese,cyrillic-ext';
    file.rel = 'stylesheet';
    file.type = 'text/css';
    file.href = link;
    app.editor.document.head.appendChild(file);
}

function addFontStyle(obj, key)
{
    var object = app.editor.$g(app.selector).closest('footer.footer').length > 0 ? app.editor.app.footer : app.editor.app.theme,
        style = document.createElement('style'),
        font = obj.font == '@default' ? getTextParentFamily(object.desktop, key) : obj.font,
        styles = obj.styles == '@default' ? getTextParentWeight(object.desktop, key) : obj.styles,
        str = "@font-face {font-family: '"+font.replace(/\+/g, ' ')+"';";
    str += 'font-weight : '+styles+';';
    str += ' src: url('+JUri+'templates/gridbox/library/fonts/'+obj.custom_src+');}';
    style.type = 'text/css';
    app.editor.document.head.appendChild(style);
    style.innerHTML = str;
}

function addFontFamily(obj, $this)
{
    var callback = $this.dataset.callback,
        key = (app.edit.type == 'text' || app.edit.type == 'headline') ? $this.dataset.group : 'body',
        subgroup = $this.dataset.subgroup,
        group = $this.dataset.group;
    if (!obj.custom_src) {
        addFontLink(obj, key);
    } else {
        addFontStyle(obj, key);
    }
    if (!subgroup) {
        app.edit.desktop[group]['font-family'] = obj.font;
        app.edit.desktop[group]['font-weight'] = obj.styles;
        app.edit.desktop[group]['custom'] = obj.custom_src;
    } else {
        app.edit.desktop[group][subgroup]['font-family'] = obj.font;
        app.edit.desktop[group][subgroup]['font-weight'] = obj.styles;
        app.edit.desktop[group][subgroup]['custom'] = obj.custom_src;
    }
    setTimeout(function(){
        app[callback]();
        if (callback != 'sectionRules') {
            app.sectionRules();
        }
    }, 300);
    app.addHistory();
}

function getTextParentFamily(obj, key)
{
    var family = obj[key]['font-family'];
    if (family == '@default') {
        family = obj.body['font-family'];
    }

    return family;
}

function getTextParentWeight(obj, key)
{
    var weight = obj[key]['font-weight'];
    if (weight == '@default') {
        weight = obj.body['font-weight'];
    }

    return weight;
}

function getTextParentCustom(obj, key)
{
    var object = obj[key];
    if (object['font-family'] == '@default') {
        object = obj.body;
    }

    return object['custom'];
}

function getTextParentList(obj, key)
{
    var family = getTextParentFamily(obj, key), array;
    if (fontsLibrary[family]) {
        array = fontsLibrary[family];
    } else {
        array =  new Array();
    }

    return array;
}

$g('input[data-option="font-family"]').on('change', function(){
    var weightWrapper = $g('.font-weight-wrapper').empty(),
        parentFont = this.dataset.value;
        key = 'body',
        array = fontsLibrary[this.dataset.value],
        input = $g(this).closest('.typography-options').find('input[data-option="font-weight"]'),
        parent = app.editor.app.theme.desktop;
    if (app.edit.type == 'text' || app.edit.type == 'headline') {
        key = this.dataset.group;
    }
    if (!app.edit.type || app.edit.type == 'footer') {
        app.editor.app.setNewFont = true;
        app.editor.app.fonts = {};
        app.editor.app.customFonts = {};
    }
    if (app.editor.$g(app.selector).closest('footer.footer').length > 0) {
        parent = app.editor.app.footer.desktop;
    }
    if (this.dataset.value == '@default') {
        parentFont = parent[key]['font-family'];
        if (parentFont == '@default') {
            parentFont = parent.body['font-family'];
        }
        array = getTextParentList(parent, key);
        var object = {
                font: this.dataset.value,
                styles: this.dataset.value,
                custom_src: getTextParentCustom(parent, key)
            };
    } else {
        var object = $g.extend({}, array[0]);
    }
    if (this.dataset.group != 'body') {
        object.styles = '@default';
    }
    if (this.dataset.group != 'body') {
        var str = '<span class="font-weight-title">'+gridboxLanguage['BASE_FONT_WEIGHT'],
            inheritFont = this.dataset.value,
            inheritWeight = parent[key]['font-weight'];
        if (inheritFont == '@default') {
            inheritFont = parent[key]['font-family'];
        }    
        if (inheritFont == '@default') {
            inheritFont = parent['body']['font-family'];
        }
        if (inheritWeight == '@default') {
            inheritWeight = parent['body']['font-weight'];
        }
        str += '</span><span class="font-family-title">'+inheritWeight.replace('i', 'Italic')+'</span>';
        var p = document.createElement('p');
        p.dataset.value = '@default';
        p.style.fontFamily = "'"+inheritFont.replace(/\+/g, ' ')+"'";
        p.style.fontWeight = inheritWeight.replace('i', '');
        p.style.fontStyle = inheritWeight.indexOf('i') == -1 ? 'normal' : 'italic';
        p.innerHTML = str;
        weightWrapper.append(p);
    }
    for (var i = 0; i < array.length; i++) {
        var weight = array[i].styles,
            str = '<span class="font-weight-title">'+weight.replace('i', ' Italic')+
            '</span><span class="font-family-title">'+parentFont.replace(/\+/g, ' ')+'</span>';
        var p = document.createElement('p');
        p.dataset.value = weight;
        p.style.fontFamily = "'"+parentFont.replace(/\+/g, ' ')+"'";
        p.style.fontWeight = weight.replace('i', '');
        p.style.fontStyle = weight.indexOf('i') == -1 ? 'normal' : 'italic';
        p.innerHTML = str;
        weightWrapper.append(p);
    }
    var value = object.styles == '@default' ? gridboxLanguage['INHERIT'] : object.styles.replace('i', ' Italic');
    input.attr('data-value', object.styles).val(value);
    addFontFamily(object, this);
});

$g('input[data-option="font-weight"]').on('change', function(){
    var font = $g(this).closest('.typography-options').find('input[data-option="font-family"]')[0].dataset.value,
        obj = {};
    if (font == '@default' || this.dataset.value == '@default') {
        var key = 'body';
        if (app.edit.type == 'text' || app.edit.type == 'headline') {
            key = this.dataset.group;
        }
        if (app.editor.$g(app.selector).closest('footer.footer').length > 0) {
            var parent = app.editor.app.footer.desktop;
        } else {
            var parent = app.editor.app.theme.desktop;
        }
        obj = {
            font: font,
            styles: this.dataset.value,
            custom_src: font == '@default' ? getTextParentCustom(parent, key) : fontsLibrary[font][0].custom_src
        }
        if (this.dataset.value != '@default' && !this.dataset.subgroup) {
            obj.custom_src = app.edit.desktop[this.dataset.group]['custom'];
        } else if (this.dataset.value != '@default') {
            obj.custom_src = app.edit.desktop[this.dataset.group][this.dataset.subgroup]['custom'];
        }
    } else {
        for (var i = 0; i < fontsLibrary[font].length; i++) {
            if (fontsLibrary[font][i].styles == this.dataset.value) {
                obj = fontsLibrary[font][i];
            }
        }
    }
    if (!app.edit.type || app.edit.type == 'footer') {
        app.editor.app.setNewFont = true;
        app.editor.app.fonts = {};
        app.editor.app.customFonts = {};
    }
    addFontFamily(obj, this);
});

$g('.create-new-preset').on('click', function(){
    $g('.preset-title').val('');
    $g('#save-preset').removeClass('active-button').addClass('disable-button').attr('data-key', '');
    $g('.save-as-default-preset').prop('checked', false);
    $g('#create-preset-dialog').modal();
    $g(this).closest('.select-preset').trigger('click');
});

$g('.edit-preset-item').on('click', function(){
    if (!this.classList.contains('disable-button')) {
        $g('.preset-title').val(app.editor.app.theme.presets[app.edit.type][this.dataset.value].title);
        $g('#save-preset').removeClass('active-button').addClass('disable-button').attr('data-key', this.dataset.value);
        $g('.save-as-default-preset').prop('checked', app.editor.app.theme.defaultPresets[app.edit.type] == this.dataset.value);
        $g('#create-preset-dialog').modal();
        $g(this).closest('.select-preset').trigger('click');
    }
});

$g('.delete-preset-item').on('click', function(){
    if (!this.classList.contains('disable-button')) {
        app.itemDelete = 'ba-delete-preset:'+this.dataset.value;
        app.checkModule('deleteItem');
        $g(this).closest('.select-preset').trigger('click');
    }
});

$g('.save-as-default-preset').on('change', function(){
    var value = $g('.preset-title').val().trim();
    if (value) {
        $g('#save-preset').addClass('active-button').removeClass('disable-button');
    } else {
        $g('#save-preset').removeClass('active-button').addClass('disable-button');
    }
});

$g('.preset-title').on('input', function(){
    if (this.value.trim() && !app.editor.app.theme.presets[app.edit.type][this.value.trim()]) {
        $g('#save-preset').addClass('active-button').removeClass('disable-button');
    } else {
        $g('#save-preset').removeClass('active-button').addClass('disable-button');
    }
});

$g('#save-preset').on('click', function(event){
    event.preventDefault();
    if (this.classList.contains('active-button')) {
        if (!this.dataset.key) {
            var patern = presetsPatern[app.edit.type],
                title = $g('.preset-title').val().trim(),
                value = title,
                obj = {};
            for (var ind in patern) {
                if (ind == 'desktop') {
                    obj[ind] = {};
                    for (var key in patern[ind]) {
                        obj[ind][key] = $g.extend(true, {}, app.edit[ind][key]);
                    }
                    for (var ind in app.editor.breakpoints) {
                        if (app.edit[ind]) {
                            obj[ind] = {};
                            for (var key in patern.desktop) {
                                if (obj[ind][key]) {
                                    obj[ind][key] = $g.extend(true, {}, app.edit[ind][key]);
                                } else {
                                    obj[ind][key] = {};
                                }
                            }
                        }
                    }
                } else {
                    obj[ind] = $g.extend(true, {}, app.edit[ind]);
                }
            }
            app.editor.app.theme.presets[app.edit.type][value] = {
                'title': title,
                'data' : obj
            };
            app.edit.preset = value;
            app.editor.comparePresets(app.edit);
            checkPresetProperties();
            app.addHistory();
        } else {
            var title = $g('.preset-title').val().trim(),
                value = this.dataset.key;
            app.editor.app.theme.presets[app.edit.type][value].title = title;
            if (!$g('.save-as-default-preset').prop('checked') && app.editor.app.theme.defaultPresets[[app.edit.type]] == value) {
                delete(app.editor.app.theme.defaultPresets[[app.edit.type]]);
            }
        }
        if ($g('.save-as-default-preset').prop('checked')) {
            app.editor.app.theme.defaultPresets[[app.edit.type]] = value;
        }
        app.editor.app.checkModule('editItem');
        $g('#create-preset-dialog').modal('hide');
    }
});

$g('.select-preset').on('customAction', function(){
    app.edit.preset = this.querySelector('input[type="hidden"]').value;
    app.editor.comparePresets(app.edit);
    app.editor.app.checkModule('editItem');
    app.editor.app.setNewFont = true;
    app.editor.app.fonts = {};
    app.editor.app.customFonts = {};
    app.sectionRules();
    checkPresetProperties();
    app.addHistory();
});

function checkPresetProperties()
{
    if (app.edit.preset) {
        if (app.edit.desktop.shape && 'setShapeDividers' in window) {
            var str = '.ba-'+app.edit.type.replace('column', 'grid-column');
            app.editor.$g(str).each(function(){
                if (app.editor.app.items[this.id] && app.editor.app.items[this.id].preset == app.edit.preset) {
                    setShapeDividers(app.editor.app.items[this.id], this.id);
                }
            });
        }
        if (app.edit.type == 'progress-pie') {
            app.drawPieLine();
        }
        app.editor.$g(app.selector).closest('li').trigger('mouseenter');
    }
}

function setPresetsList(modal)
{
    if (app.edit.preset && app.editor.app.theme.presets[app.edit.type] && app.editor.app.theme.presets[app.edit.type][app.edit.preset]) {
        modal.find('.select-preset input[type="hidden"]').val(app.edit.preset)
            .prev().val(app.editor.app.theme.presets[app.edit.type][app.edit.preset].title);
    } else {
        modal.find('.select-preset input[type="hidden"]').val('');
        modal.find('.select-preset input[type="text"]').val(gridboxLanguage['NO_NE']);
    }
    getPresetsLi(modal);
}

function getPresetsLi(modal)
{
    var str = getPresetLi('', gridboxLanguage['NO_NE']);
    if (!app.editor.app.theme.presets[app.edit.type]) {
        app.editor.app.theme.presets[app.edit.type] = {};
    }
    for (var ind in app.editor.app.theme.presets[app.edit.type]) {
        str += getPresetLi(ind, app.editor.app.theme.presets[app.edit.type][ind].title);
    }
    modal.find('.select-preset .ba-lg-custom-select-body').empty().append(str);
}

function getPresetLi(value, title)
{
    var str = '<li data-value="'+value+'"><label>';
    str += '<input type="radio" name="preset-checkbox" value="'+value+'">';
    str += '<i class="zmdi zmdi-circle-o"></i><i class="zmdi zmdi-check"></i></label><span>'+title+'</span>';
    if (app.editor.app.theme.defaultPresets[app.edit.type] == value) {
        str += '<i class="zmdi zmdi-star"></i>';
    }
    str += '</li>';

    return str;
}

app.drawPieLine = function(){
    app.editor.$g('.ba-item-progress-pie').each(function(){
        var canvas = this.querySelector('canvas'),
            context = canvas.getContext('2d'),
            obj = app.editor.app.items[this.id],
            view = app.editor.getProgressPieObject(this.id);
        canvas.width = view.width;
        canvas.height = canvas.width;
        context.lineCap = 'round';
        app.editor.drawPieLine(obj.target * 3.6, canvas, context, this);
    });
}

$g('#image-settings-dialog, #countdown-settings-dialog').find('.sorting-container').on('click', '.zmdi.zmdi-edit', function(){
    var title = '',
        description = '';
    if (!app.edit.caption) {
        app.edit.caption = {
            title: '',
            description: '',
        }
    }
    $g('.image-item-upload-image').val(app.edit.image);
    $g('.image-item-alt').val(app.edit.alt);
    $g('.image-item-title').val(app.edit.caption.title);
    $g('.image-item-description').val(app.edit.caption.description);
    $g('#image-item-edit-modal').modal();
});

$g('.image-item-upload-image').on('click', function(){
    uploadMode = 'reselectSimpleImage';
    fontBtn = this;
    checkIframe($g('#uploader-modal').attr('data-check', 'single'), 'uploader');
});

$g('#apply-image-item').on('click', function(event){
    event.preventDefault();
    var wrapper = app.editor.$g(app.selector+' > .ba-image-wrapper').addClass(app.edit.desktop.animation.effect)[0],
        image = wrapper.querySelector('img'),
        title = wrapper.querySelector('.ba-image-item-title'),
        description = wrapper.querySelector('.ba-image-item-description');
    app.edit.image = $g('.image-item-upload-image').val();
    app.edit.alt = $g('.image-item-alt').val().trim();
    app.edit.caption.title = $g('.image-item-title').val().trim();
    app.edit.caption.description = $g('.image-item-description').val().trim();
    image.src = JUri+app.edit.image;
    image.alt = app.edit.alt;
    if (!title) {
        var caption = '<div class="ba-image-item-caption">'+
            '<div class="ba-caption-overlay"></div><'+app.edit.tag+' class="ba-image-item-title"></'+app.edit.tag+'>'+
            '<div class="ba-image-item-description"></div></div>';
        $g(wrapper).append(caption);
        title = wrapper.querySelector('.ba-image-item-title');
        description = wrapper.querySelector('.ba-image-item-description');
    }
    if (!app.edit.caption.title) {
        title.classList.add('empty-content');
    } else {
        title.classList.remove('empty-content');
    }
    if (!app.edit.caption.description) {
        description.classList.add('empty-content');
    } else {
        description.classList.remove('empty-content');
    }
    title.textContent = app.edit.caption.title;
    description.innerHTML = app.edit.caption.description;
    app.addHistory();
    $g('#image-general-options, #countdown-general-options').find('.sorting-item').each(function(){
        this.querySelector('img').src = JUri+app.edit.image;
        var array = app.edit.image.split('/');
        this.querySelector('.sorting-title').textContent = array[array.length - 1];
    });
    $g('#image-item-edit-modal').modal('hide');
});

$g('.image-item-caption-effect-select').on('customAction', function(){
    app.editor.$g('#'+app.editor.app.edit+' > .ba-image-wrapper').removeClass(app.edit.desktop.animation.effect);
    app.edit.desktop.animation.effect = this.querySelector('input[type="hidden"]').value;
    app.editor.$g('#'+app.editor.app.edit+' > .ba-image-wrapper').addClass(app.edit.desktop.animation.effect);
    app.addHistory();
});

$g('.button-embed-code').on('input', function(){
    var $this = this;
    clearTimeout(this.embedDelay);
    this.embedDelay = setTimeout(function(){
        var a = app.editor.$g(app.selector+' a');
        if (a.length > 0) {
            var html = a.html(),
                str = '<a class="ba-btn-transition"';
            if (app.edit.link) {
                ' target="'+app.edit.link.target+'"';
                if (app.edit.link.link) {
                    str += ' href="'+app.edit.link.link+'"';
                }
                if (app.edit.link.type) {
                    str += ' download';
                }
            }
            str += ' '+$this.value;
            str += '></a>';
            var div = document.createElement(div);
            div.innerHTML = str;
            if (div.querySelector('a')) {
                div.querySelector('a').innerHTML = html;
                a.replaceWith(div.querySelector('a'));
            }
        }
        app.edit.embed = $this.value;
        app.addHistory();
    }, 300);
});

$g('.select-title-html-tag').on('customAction', function(){
    var tag = this.querySelector('input[type="hidden"]').value;
    if (tag != app.edit.tag) {
        app.editor.$g(app.selector+' '+app.edit.tag+'[class*="-title"]').each(function(){
            var h = document.createElement(tag);
            h.className = this.className;
            h.innerHTML = this.innerHTML;
            $g(this).replaceWith(h);
        });
        app.edit.tag = tag;
        app.addHistory();
    }
});

function replaceBlogPostsTag()
{
    if (app.edit.tag != 'h3') {
        app.editor.$g(app.selector+' h3[class*="-title"]').each(function(){
            var h = document.createElement(app.edit.tag);
            h.className = this.className;
            h.innerHTML = this.innerHTML;
            $g(this).replaceWith(h);
        });
    }
}

app.loadModule('presetsPatern');
setTabsAnimation();