/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

var onePageScroll = true,
    pageAS = {
        scrolling :false,
        delta :1,
        startCoords : {},
        endCoords : {},
        anchor : jQuery('.gridbox-class'),
        animateScroll: function(){
            if (onePageScroll && pageAS.anchor.length > 0) {
                var scroll = $g(window).scrollTop(),
                    index = 0,
                    header = $g('header.header'),
                    comp = header[0] ? getComputedStyle(header[0]) : {};
                pageAS.anchor.each(function(ind){
                    var value = $g(this).offset().top,
                        li = $g('.ba-item-one-page-menu li a[href="#'+this.id+'"][data-alias]'),
                        wrapper = li.closest('.ba-wrapper');
                    header = wrapper.hasClass('ba-sticky-header') ? wrapper : $g('header.header');
                    comp = header[0] ? getComputedStyle(header[0]) : {};
                    if (!header.hasClass('sidebar-menu') && comp.position == 'fixed') {
                        value -= header.height();
                        if (header.find('.resizing-header').length > 0) {
                            var resizingSection = getComputedStyle(header.find('.resizing-header')[0]);
                            value += resizingSection.paddingTop.replace('px', '') * 1;
                            value += resizingSection.paddingBottom.replace('px', '') * 1;
                        }
                    }
                    if ($g(this).closest('.ba-wrapper').parent().hasClass('header')) {
                        value = 0;
                    }
                    if (Math.floor(value) == Math.floor(scroll)) {
                        index = ind + (-1 * pageAS.delta);
                        return false;
                    }
                });
                if (index >= 0 && index < pageAS.anchor.length) {
                    pageAS.scrolling = true;
                    var obj = app.items[this.item].autoscroll,
                        section = jQuery(pageAS.anchor[index]),
                        value = section.offset().top;
                    if (!header.hasClass('sidebar-menu') && comp.position == 'fixed') {
                        value -= header.height();
                        if (header.find('.resizing-header').length > 0) {
                            var resizingSection = getComputedStyle(header.find('.resizing-header')[0]);
                            value += resizingSection.paddingTop.replace('px', '') * 1;
                            value += resizingSection.paddingBottom.replace('px', '') * 1;
                        }
                    }
                    if (section.closest('.ba-wrapper').parent().hasClass('header')) {
                        value = 0;
                    }
                    onePageScroll = false;
                    jQuery('html, body').stop().animate({
                        scrollTop: value
                    }, obj.speed * 1, obj.animation, function(){
                        if (window.pageYOffset != value) {
                            window.scrollTo(0, value);
                        }
                        onePageScroll = true;
                        checkOnePageActive();
                        setTimeout(function(){
                            pageAS.scrolling = false;
                        }, 200);
                    });
                }
            }
        },
        wheelHandle: function(event){
            pageAS.checkItems();
            if (pageAS.anchor.length > 0) {
                event.preventDefault();
                var value = event.originalEvent.wheelDelta || -event.originalEvent.deltaY || -event.originalEvent.detail;
                pageAS.delta = Math.max(-1, Math.min(1, value));
                if (pageAS.scrolling) {
                    return false;
                }
                pageAS.animateScroll();
            }
        },
        keydownHandle: function(event){
            var flag = false;
            if (flag = event.keyCode == 38 || event.keyCode == 33) {
                pageAS.delta = 1;
            } else if (flag = event.keyCode == 40 || event.keyCode == 34) {
                pageAS.delta = -1;
            }
            if (flag) {
                pageAS.checkItems();
                if (pageAS.anchor.length > 0) {
                    event.preventDefault();            
                    if (!pageAS.scrolling) {
                        pageAS.animateScroll();
                    }
                }
            }
        },
        checkItems: function(){
            if (app.view != 'desktop') {
                this.anchor = new Array();
            } else {
                var items = '';
                $g('#'+this.item).find('> .ba-menu-wrapper > .main-menu > .integration-wrapper > ul li a').each(function(){
                    if ($g(this).height() > 0 && this.hash && $g(this.hash).height() > 0) {
                        if (items) {
                            items += ', ';
                        }
                        items += this.hash;
                    }
                });
                this.anchor = $g(items);
            }
        },
        setEvents: function(key){
            this.item = key;
            pageAS[key] = true;
            $g(window).on('wheel.'+key, pageAS.wheelHandle);
            $g(window).on('keydown.'+key, pageAS.keydownHandle);
        },
        removeEvents: function(key){
            if (pageAS[key]) {
                $g(window).off('wheel.'+key);
                $g(window).off('keydown.'+key);
            }
        }
    }

app['initone-page'] = function(obj, key){
    if (!obj.autoscroll) {
        obj.autoscroll = {
            "enable": false,
            "speed": 1000,
            "animation": "easeInSine"
        }
    }
    if (themeData.page.view != 'gridbox' && obj.autoscroll.enable) {
        pageAS.setEvents(key);
    } else {
        pageAS.removeEvents(key);
    }
    $g('#'+key+' > .ba-menu-wrapper > .open-menu i').on('mousedown', function(event){
        if (event.button && event.button != 0) {
            return false;
        }
        event.stopPropagation();
        setTimeout(function(){
            var width = window.innerWidth - document.documentElement.clientWidth;
            $g('#'+key+' > .ba-menu-wrapper > .main-menu').addClass('visible-menu').removeClass('hide-menu').css('right', -width+'px')
                .closest('.column-wrapper').addClass('column-with-menu').closest('.ba-row-wrapper').addClass('row-with-menu');
            if (themeData.page.view == 'gridbox') {
                var computed = getComputedStyle(document.querySelector('header'));
                document.querySelector('header').classList.add('ba-header-position-'+computed.position);
            }
            $g('#'+key+' > .ba-menu-backdrop').addClass('ba-visible-menu-backdrop');
            $g('body').addClass('ba-opened-menu');
        }, 50);
    });
    $g('#'+key+' > .ba-menu-backdrop, #'+key+' > .ba-menu-wrapper > .main-menu > .close-menu i').off('click').on('click', function(){
        closeOnePageMenu();
    });
    $g('#'+key+' > .ba-menu-wrapper > .main-menu > .integration-wrapper > ul').on('click', ' > li > a', function(event){
        event.preventDefault();
        var item = $g(this.hash);
        if (this.hash && item.length > 0) {
            $g(this).closest('ul').find('.active').removeClass('active');
            this.parentNode.classList.add('active');
            var value = item.offset().top,
                speed = app.items[key].autoscroll.speed * 1,
                animation = app.items[key].autoscroll.animation,
                wrapper = $g(this).closest('.ba-wrapper'),
                header = wrapper.hasClass('ba-sticky-header') ? wrapper : $g('header.header'),
                comp = header[0] ? getComputedStyle(header[0]) : {},
                alias = this.dataset.alias,
                url = location.href.replace(location.hash, '')+'#'+alias,
                top = window.pageYOffset;
            if (item.closest('.ba-wrapper').parent().hasClass('header')) {
                value = 0;
            }
            if (!header.hasClass('sidebar-menu') && comp.position == 'fixed') {
                value -= header.height();
                if (header.find('.resizing-header').length > 0) {
                    var resizingSection = getComputedStyle(header.find('.resizing-header')[0]);
                    value += resizingSection.paddingTop.replace('px', '') * 1;
                    value += resizingSection.paddingBottom.replace('px', '') * 1;
                }
            }
            $g('.ba-item-one-page-menu a[href="'+this.hash+'"]').not(this).each(function(){
                $g(this).closest('ul').find('.active').removeClass('active');
                this.parentNode.classList.add('active');
            });
            if (top != value) {
                onePageScroll = false;
                $g('html, body').stop().animate({
                    'scrollTop' : value
                }, speed, animation, function(){
                    setTimeout(function(){
                        onePageScroll = true;
                    }, 200);
                });
            }
            window.history.replaceState(null, null, url);
        }
        closeOnePageMenu();
    });
    if (themeData.page.view != 'gridbox') {
        var endCoords = startCoords = {};
        $g('#'+key).on('touchstart', function(event){
            endCoords = event.originalEvent.targetTouches[0];
            startCoords = event.originalEvent.targetTouches[0];
        }).on('touchmove', function(event){
            endCoords = event.originalEvent.targetTouches[0];
        }).on('touchend', function(event){
            var hDistance = endCoords.pageX - startCoords.pageX,
                xabs = Math.abs(endCoords.pageX - startCoords.pageX),
                yabs = Math.abs(endCoords.pageY - startCoords.pageY);
            if(hDistance >= 100 && xabs >= yabs * 2) {
                $g('#'+key+' .ba-menu-backdrop').trigger('click');
            }
        });
    } else {
        var addNewItem = $g('#'+key+' > .ba-menu-wrapper > .main-menu > .add-new-item');
        if (addNewItem.length == 0) {
            addNewItem = '<div class="add-new-item"><span><i class="zmdi zmdi-layers"></i>'+
                '<span class="ba-tooltip ba-top">'+top.gridboxLanguage['ADD_NEW_ITEM']+'</span></span></div>';
            $g('#'+key+' > .ba-menu-wrapper > .main-menu').append(addNewItem);
            addNewItem = $g('#'+key+' > .ba-menu-wrapper > .main-menu > .add-new-item');
        }
        addNewItem.find('i').on('click', function(){
            app.edit = $g(this).closest('.ba-item')[0].id;
            window.parent.app.checkModule('addPlugins');
        });
        if ($g('#'+key+' > .ba-edit-item .open-mobile-menu').length == 0) {
            var str = '<span class="ba-edit-wrapper"><i class="zmdi zmdi-open-in-new open-mobile-menu"></i>'+
                '<span class="ba-tooltip tooltip-delay settings-tooltip">'+window.parent.gridboxLanguage['OPEN']+
                '</span></span>';
            $g('#'+key+' > .ba-edit-item .ba-buttons-wrapper .ba-edit-wrapper').first().before(str);
        }
        $g('.open-mobile-menu').off('mousedown').on('mousedown', function(event){
            if (event.button && event.button != 0) {
                return false;
            }
            event.stopPropagation();
            $g(this).closest('.ba-item').find('> .ba-menu-wrapper > .open-menu i').first().trigger('mousedown');
        })
    }

    initItems();
}

function closeOnePageMenu()
{
    $g('.visible-menu').addClass('hide-menu').removeClass('visible-menu').css('right', '')
        .closest('.column-wrapper').removeClass('column-with-menu').closest('.ba-row-wrapper').removeClass('row-with-menu');
    $g('.ba-menu-backdrop').removeClass('ba-visible-menu-backdrop');
    setTimeout(function(){
        if (themeData.page.view == 'gridbox') {
            var computed = getComputedStyle(document.querySelector('header'));
            document.querySelector('header').classList.remove('ba-header-position-'+computed.position);
        }
        $g('body').removeClass('ba-opened-menu');
    }, 500);
}

if (!$g('body').hasClass('gridbox')) {
    $g(window).off('scroll.onepage').on('scroll.onepage', function(){
        if (onePageScroll) {
            checkOnePageActive();
        }
    });
}

app['initone-page'](app.modules['initone-page'].data, app.modules['initone-page'].selector);