/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

app.openPageSettings = function(){
    setTimeout(function(){
        $g("#settings-dialog").modal();
    }, 150);
}

$g('.ba-custom-author-select > i, div.ba-custom-author-select input').on('click', function(event){
    var $this = $g(this),
        parent = $this.parent();
    if (!parent.find('ul').hasClass('visible-select')) {
        event.stopPropagation();
        $g('.visible-select').removeClass('visible-select');
        parent.find('ul').addClass('visible-select');
        parent.find('li').off('click').one('click', function(){
            var text = this.textContent.trim(),
                image = this.dataset.image,
                authors = new Array()
                author = '',
                li = parent.find('li[data-value]'),
                val = this.dataset.value,
                str = '<span class="selected-author" data-id="'+val
            str += '"><span class="ba-author-avatar" style="background-image: url(';
            str += image+')"></span><span class="ba-author-name">'+text+'</span>';
            str += '<i class="zmdi zmdi-close remove-selected-author"></i></span>';
            parent.before(str);
            parent.trigger('customAction');
            parent.parent().find('.selected-author').each(function(){
                authors.push(this.dataset.id);
            });
            li.each(function(){
                if (authors.indexOf(this.dataset.value) == -1) {
                    this.style.display = ''
                } else {
                    this.style.display = 'none';
                }
            });
            if (li.length == authors.length) {
                $g('.select-post-author').hide();
            } else {
                $g('.select-post-author').css('display', '');
            }
            author = authors.join(',');
            parent.find('input[type="hidden"]').val(author);
        });
        parent.trigger('show');
        setTimeout(function(){
            $g('body').one('click', function(){
                $g('.visible-select').parent().trigger('customHide');
                $g('.visible-select').removeClass('visible-select');
            });
        }, 50);
    }
});

$g(document).on('click', '.remove-selected-author', function(){
    $g(this).parent().remove();
    var authors = new Array(),
        li = $('.select-post-author li[data-value]'),
        author = '';
    $g('.selected-author').each(function(){
        authors.push(this.dataset.id);
    });
    li.each(function(){
        if (authors.indexOf(this.dataset.value) == -1) {
            this.style.display = ''
        } else {
            this.style.display = 'none';
        }
    });
    if (li.length == authors.length) {
        $g('.select-post-author').hide();
    } else {
        $g('.select-post-author').css('display', '');
    }
    author = authors.join(',');
    $g('.select-post-author input[type="hidden"]').val(author);
});

$g("#settings-dialog").on('hide', function(){
    var metaTags = $g('select.meta_tags option'),
        str = '';
    if (metaTags.length > 0) {
        metaTags.each(function(){
            str += '<a href="#" class="ba-btn-transition"><span>'+this.textContent+'</span></a>';
        });
        var items = app.editor.document.querySelectorAll('.ba-item-post-tags .ba-button-wrapper');
        for (var i = 0; i < items.length; i++) {
            items[i].innerHTML = str;
        }
    }
});

$g('.page-class-suffix').on('input', function(){
    app.editor.$g('body').removeClass(this.dataset.value).addClass(this.value).addClass('gridbox com_gridbox');
    this.dataset.value = this.value;
});

$g("#settings-dialog").on('shown', function(){
    $g('.alert-backdrop').addClass('active');
}).on('hide', function(){
    $g('.alert-backdrop').removeClass('active');
});

$g('div.alert-backdrop, #settings-dialog .modal-header-icon i').on('mousedown', function(event){
    event.preventDefault();
    event.stopPropagation();
    var title = $g('.page-title').val();
    title = $g.trim(title);
    if (title) {
        $g("#settings-dialog").modal('hide');
        $g('.alert-backdrop').removeClass('active');
    }
});

$g('.page-title').on('input', function(){
    var $this = $g(this),
        title = $this.val();
    title = $g.trim(title);
    if (!title) {
        $g('#settings-dialog i.zmdi-check').addClass('disabled-button');
        $this.parent().find('.ba-alert-container').show();
    } else {
        $g('#settings-dialog i.zmdi-check').removeClass('disabled-button');
        $this.parent().find('.ba-alert-container').hide();
    }
});

$g('.reset-page-intro-image').on('click', function(){
    $g('input.intro-image').val('');
});

if (!app.editor.themeData.edit_type) {
    var func = function(){
        setupCalendar('published_on', 'calendar-button');
        setupCalendar('published_down', 'calendar-end-button');
    }

    if (!app.modules.calendar) {
        if (!app.actionStack['calendar']) {
            app.actionStack['calendar'] = new Array();
        }
        app.actionStack['calendar'].push(func);
        app.loadModule('calendar');
    } else if (app.modules.calendar) {
        func();
    }

    $g('.select-intro-image').on('mousedown', function(event){
        event.preventDefault();
        uploadMode = 'introImage';
        checkIframe($g('#uploader-modal').attr('data-check', 'single'), 'uploader');
    });

    $g('.meta-tags .picked-tags .search-tag input').on('keydown', function(event){
        var title = $g(this).val().trim().toLowerCase();
        $g('ul.all-tags').css({
            'left': this.parentNode.offsetLeft
        });
        if (event.keyCode == 13) {
            if (!title) {
                this.value = '';
                return false;
            }
            var str = '<li class="tags-chosen"><span>',
                tagId = 'new$'+title;
            $g('.all-tags li').each(function(){
                var search = $g(this).text().trim().toLowerCase();
                if (title == search) {
                    this.classList.add('selected-tag');
                    tagId = this.dataset.id;
                    return false;
                }
            });
            if ($g('.picked-tags .tags-chosen i[data-remove="'+tagId+'"]').length > 0) {
                return false;
            }
            str += title+'</span><i class="zmdi zmdi-close" data-remove="'+tagId+'"></i></li>';
            $g('.picked-tags .search-tag').before(str);
            str = '<option value="'+tagId+'" selected>'+title+'</option>';
            $g('select.meta_tags').append(str);
            $g(this).val('');
            $g('.all-tags li').hide();
            event.stopPropagation();
            event.preventDefault();
            return false;
        } else {
            $g('.all-tags li').each(function(){
                var search = $g(this).text().trim().toLowerCase();
                if (search.indexOf(title) < 0 || title == '') {
                    $g(this).hide();
                } else {
                    $g(this).show();
                }
            });
        }
    });

    $g('.all-tags').on('click', 'li', function(){
        if (this.classList.contains('selected-tag')) {
            return false;
        }
        var title = $g(this).text().trim(),
            tagId = this.dataset.id;
        var str = '<li class="tags-chosen"><span>';
        str += title+'</span><i class="zmdi zmdi-close" data-remove="'+tagId+'"></i></li>';
        $g('.picked-tags .search-tag').before(str);
        str = '<option value="'+tagId+'" selected>'+title+'</option>';
        $g('select.meta_tags').append(str);
        $g('.meta-tags .picked-tags .search-tag input').val('');
        $g('.all-tags li').hide();
        this.classList.add('selected-tag');
    });

    $g('.meta-tags .picked-tags').on('click', '.zmdi.zmdi-close', function(){
        var del = this.dataset.remove;
        $g('select.meta_tags option[value="'+del+'"]').remove();
        $g(this).closest('li').remove();
        $g('.all-tags li[data-id="'+del+'"]').removeClass('selected-tag');
        $g('.all-tags li').hide();
    });
}

app.openPageSettings();
app.modules.openPageSettings = true;