/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

app.slideshowEditor = function(){
    app.selector = '#'+app.editor.app.edit;
    $g('#slideshow-settings-dialog .active').removeClass('active');
    $g('#slideshow-settings-dialog a[href="#slideshow-general-options"]').parent().addClass('active');
    $g('#slideshow-general-options').addClass('active');
    var li = app.editor.document.querySelectorAll('#'+app.editor.app.edit+' ul li.item'),
        value;
    sortingList = [];
    $g('#slideshow-settings-dialog .sorting-container').html('');
    value = app.getValue('slides');
    setPresetsList($g('#slideshow-settings-dialog'));
    if (!app.edit.tag) {
        app.edit.tag = 'h3';
    }
    $g('#slideshow-settings-dialog .tab-content [style*="display"]').css('display', '');
    if (app.edit.type != 'recent-posts-slider') {
        if (!app.edit.lightbox) {
            app.edit.popup = false;
            app.edit.lightbox = {
                color: '@overlay'
            }
        }
        $g('#slideshow-settings-dialog input[data-option="popup"]').prop('checked', app.edit.popup);
        updateInput($g('#slideshow-settings-dialog [data-option="color"][data-group="lightbox"]'), app.edit.lightbox.color);
        $g('#slideshow-settings-dialog').find('input[data-option="popup"], input[data-group="lightbox"]')
            .closest('.ba-settings-group').css('display', '');
        $g('#slideshow-settings-dialog').find('.ba-settings-group.items-list, li[data-value="description"]').css('display', '');
        $g('#slideshow-settings-dialog').find('li[data-value="info"], li[data-value="intro"]').hide();
        $g('#slideshow-settings-dialog .slideshow-options:not(.carousel-options)').css('display', '');
        $g('#slideshow-settings-dialog .slideset-options:not(.carousel-options)').css('display', '');
        $g('#slideshow-settings-dialog .recent-posts-slider-options').hide();
        for (var i = 0; i < li.length; i++) {
            if (!value[i + 1]) {
                value[i + 1] = {
                    image: "",
                    type: "image",
                    link: "",
                    embed: "",
                    video: null
                }
            }
            var slide = value[i + 1],
                img = li[i].querySelector('.ba-slideshow-img'),
                title = li[i].querySelector('.ba-slideshow-title').textContent,
                description = li[i].querySelector('.ba-slideshow-description').innerHTML,
                button = li[i].querySelector('.ba-btn-transition'),
                obj = {
                    index : i + 1,
                    title : title,
                    description : description,
                    image : slide.image,
                    type : slide.type,
                    video : slide.video,
                    button : {
                        href : $g(button).attr('href'),
                        embed: '',
                        type : button.className,
                        title : button.textContent,
                        download: button.getAttribute('download'),
                        target : button.target
                    }
                }
            if (typeof(value[i + 1].link) != 'undefined') {
                obj.button.href = value[i + 1].link;
            }
            if (typeof(value[i + 1].embed) != 'undefined') {
                obj.button.embed = value[i + 1].embed;
            }
            if (app.view != 'desktop') {
                obj.type = 'image';
            }
            sortingList.push(obj);
            $g('#slideshow-settings-dialog .sorting-container').append(addSlideSortingList(obj, i));
            $g('#slideshow-settings-dialog .slideshow-size-select').parent().css('display', '');
        }
    } else {
        if (!('featured' in app.edit)) {
            app.edit.featured = false;
        }
        $g('#slideshow-settings-dialog').find('input[data-option="popup"], input[data-group="lightbox"]')
            .closest('.ba-settings-group').hide();
        $g('#slideshow-settings-dialog input[data-option="featured"]').prop('checked', app.edit.featured);
        $g('#slideshow-settings-dialog .recent-posts-layout-select input[type="hidden"]').val(app.edit.layout);
        value = $g('#slideshow-settings-dialog .recent-posts-layout-select li[data-value="'+app.edit.layout+'"]').text().trim();
        $g('#slideshow-settings-dialog .recent-posts-layout-select input[type="text"]').val(value);
        $g('#slideshow-settings-dialog').find('.ba-settings-group.items-list, li[data-value="description"]').hide();
        $g('#slideshow-settings-dialog').find('li[data-value="info"], li[data-value="intro"]').css('display', '');
        $g('#slideshow-settings-dialog .slideshow-options:not(.carousel-options)').hide();
        $g('#slideshow-settings-dialog .slideset-options:not(.carousel-options)').hide();
        $g('#slideshow-settings-dialog .recent-posts-slider-options').css('display', '');
        $g('#slideshow-settings-dialog .recent-posts-slider-options input[data-group="view"]').each(function(){
            value = app.getValue('view', this.dataset.option);
            this.checked = value;
        });
        $g('#slideshow-settings-dialog .recent-posts-app-select input[type="hidden"]').val(app.edit.app);
        value = $g('#slideshow-settings-dialog .recent-posts-app-select li[data-value="'+app.edit.app+'"]').text().trim();
        $g('#slideshow-settings-dialog .recent-posts-app-select input[readonly]').val(value);
        $g('#slideshow-settings-dialog .recent-posts-display-select input[type="hidden"]').val(app.edit.sorting);
        value = $g('#slideshow-settings-dialog .recent-posts-display-select li[data-value="'+app.edit.sorting+'"]').text().trim();
        $g('#slideshow-settings-dialog .recent-posts-display-select input[readonly]').val(value);
        $g('#slideshow-settings-dialog input[data-option="limit"]').val(app.edit.limit);
        $g('#slideshow-settings-dialog input[data-option="maximum"]').val(app.edit.maximum);
        if (!app.edit.categories) {
            app.edit.categories = {};
        }
        $g('#slideshow-settings-dialog .selected-categories li:not(.search-category)').remove();
        $g('#slideshow-settings-dialog .all-categories-list .selected-category').removeClass('selected-category');
        for (var key in app.edit.categories) {
            var str = getCategoryHtml(key, app.edit.categories[key].title);
            $g('#slideshow-settings-dialog .selected-categories li.search-category').before(str);
            $g('#slideshow-settings-dialog .all-categories-list [data-id="'+key+'"]').addClass('selected-category');
        }
        if ($g('#slideshow-settings-dialog .selected-categories li:not(.search-category)').length > 0) {
            $g('#slideshow-settings-dialog .ba-settings-item.tags-categories-list').addClass('not-empty-list');
        } else {
            $g('#slideshow-settings-dialog .ba-settings-item.tags-categories-list').removeClass('not-empty-list');
        }
        $g('#slideshow-settings-dialog .tags-categories .all-categories-list li').hide();
        app.recentPostsCallback = 'getRecentPostsSlider';
        $g('#slideshow-settings-dialog .slideshow-size-select').parent().hide();
        value = app.getValue('view', 'fullscreen');
        $g('#slideshow-settings-dialog [data-option="fullscreen"]')[0].checked = value;
        $g('.slideshow-animation-select input[type="hidden"]').val(app.edit.animation);
        value = $g('.slideshow-animation-select li[data-value="'+app.edit.animation+'"]').text().trim();
        $g('.slideshow-animation-select input[readonly]').val(value);
        setRecentPostsSliderLayout();
    }    
    if (!app.edit.desktop.overlay.gradient) {
        app.edit.desktop.overlay.type = 'color';
        app.edit.desktop.overlay.gradient = {
            effect : 'linear',
            angle: '225',
            color1: 'rgba(8, 174, 234, 0.75)',
            position1: '0',
            color2: 'rgba(42, 245, 152, 0.75)',
            position2: '100'
        }
    }
    value = app.getValue('overlay', 'effect', 'gradient');
    $g('#slideshow-settings-dialog .overlay-linear-gradient').hide();
    $g('#slideshow-settings-dialog .overlay-'+value+'-gradient').css('display', '');
    $g('#slideshow-settings-dialog .overlay-gradient-options .gradient-effect-select input[type="hidden"]').val(value);
    value = $g('#slideshow-settings-dialog .overlay-gradient-options .gradient-effect-select li[data-value="'+value+'"]').text().trim();
    $g('#slideshow-settings-dialog .overlay-gradient-options .gradient-effect-select input[type="text"]').val(value);
    value = app.getValue('overlay', 'type');
    $g('#slideshow-settings-dialog .overlay-color-options, .overlay-gradient-options').hide();
    $g('#slideshow-settings-dialog .overlay-'+value+'-options').css('display', '');
    $g('#slideshow-settings-dialog .background-overlay-select input[type="hidden"]').val(value);
    value = $g('#slideshow-settings-dialog .background-overlay-select li[data-value="'+value+'"]').text().trim();
    $g('#slideshow-settings-dialog .background-overlay-select input[type="text"]').val(value);
    $g('#slideshow-settings-dialog input[data-subgroup="gradient"][data-group="overlay"]').each(function(){
        value = app.getValue('overlay', this.dataset.option, 'gradient');
        if (this.type == 'number') {
            var range = $g(this).val(value).prev().val(value);
            setLinearWidth(range);
        } else {
            updateInput($g(this), value);
        }
    });
    value = app.getValue('overlay', 'color');
    updateInput($g('#slideshow-settings-dialog [data-option="color"][data-group="overlay"]'), value);
    if (app.edit.type == 'slideshow') {
        $g('#slideshow-settings-dialog [data-group="slideshow"]').each(function(){
            if (this.type == 'checkbox') {
                this.checked = app.edit.slideshow[this.dataset.option];
            } else {
                this.value = app.edit.slideshow[this.dataset.option];
            }
        });
        value = app.getValue('view', 'fullscreen');
        $g('#slideshow-settings-dialog [data-option="fullscreen"]')[0].checked = value;
        $g('.slideshow-animation-select input[type="hidden"]').val(app.edit.animation);
        value = $g('.slideshow-animation-select li[data-value="'+app.edit.animation+'"]').text().trim();
        $g('.slideshow-animation-select input[readonly]').val(value);
        if (!app.edit.dots) {
            app.edit.dots = {
                layout: app.edit.desktop.view.dots ? 'enabled-dots' : 'disabled-dots',
                outside: false
            };
            app.edit.desktop.thumbnails = {
                count: 9,
                align: '',
                height: 75
            }
        }
        if (app.edit.dots.layout != 'thumbnails-dots') {
        	$g('#slideshow-settings-dialog [data-group="thumbnails"]').closest('.ba-settings-item').hide();
        } else {
        	$g('#slideshow-settings-dialog [data-group="thumbnails"]').closest('.ba-settings-item').css('display', '');
        }
        $g('.slideshow-navigation-select input[type="hidden"]').val(app.edit.dots.layout);
        value = $g('.slideshow-navigation-select li[data-value="'+app.edit.dots.layout+'"]').text().trim();
        $g('.slideshow-navigation-select input[readonly]').val(value);
        $g('#slideshow-settings-dialog [data-option="outside"]')[0].checked = app.edit.dots.outside;
        value = app.getValue('thumbnails', 'count');
        $g('#slideshow-settings-dialog [data-group="thumbnails"][data-option="count"]').val(value);
        value = app.getValue('thumbnails', 'height');
        var range = $g('#slideshow-settings-dialog [data-group="thumbnails"][data-option="height"]').val(value).prev().val(value);
        setLinearWidth(range);
        value = app.getValue('thumbnails', 'align');
        $g('#slideshow-settings-dialog label[data-group="thumbnails"]').each(function(){
            if (this.dataset.value == value) {
                this.classList.add('active');
            } else {
                this.classList.remove('active');
            }
        });
    } else {
        if (typeof(app.edit.desktop.slideset.pause) == 'undefined') {
            app.edit.desktop.slideset.pause = false;
        }
        $g('#slideshow-settings-dialog [data-group="slideset"]').each(function(){
            value = app.getValue('slideset', this.dataset.option);
            if (this.type == 'checkbox') {
                this.checked = value;
            } else {
                this.value = value;
            }
        });
        value = app.getValue('gutter');
        $g('#slideshow-settings-dialog [data-option="gutter"]').prop('checked', value);
        $g('.slideset-caption-select input[type="hidden"]').val(app.edit.desktop.caption.position);
        value = $g('.slideset-caption-select li[data-value="'+app.edit.desktop.caption.position+'"]').text().trim();
        $g('.slideset-caption-select input[readonly]').val(value);
        if (app.edit.desktop.caption.hover == 'caption-hover') {
            value = true;
        } else {
            value = false;
        }
        $g('#slideshow-settings-dialog [data-option="hover"][data-group="caption"]').prop('checked', value);
        if (app.edit.desktop.caption.position == '') {
            $g('#slideshow-settings-dialog [data-option="hover"][data-group="caption"]').closest('.ba-settings-item').hide();
        } else {
            $g('#slideshow-settings-dialog [data-option="hover"][data-group="caption"]').closest('.ba-settings-item').css({
                display: ''
            });
        }
        value = app.getValue('overflow');
        $g('#slideshow-settings-dialog [data-option="overflow"]').prop('checked', value);
    }
    value = app.getValue('view', 'dots');
    $g('#slideshow-settings-dialog [data-group="view"][data-option="dots"]')[0].checked = value;
    $g('#slideshow-settings-dialog .section-access-select input[type="hidden"]').val(app.edit.access);
    value = $g('#slideshow-settings-dialog .section-access-select li[data-value="'+app.edit.access+'"]').text().trim();
    $g('#slideshow-settings-dialog .section-access-select input[readonly]').val(value);
    value = app.getValue('view', 'height');
    var range = $g('#slideshow-settings-dialog [data-group="view"][data-option="height"]').val(value).prev().val(value);
    setLinearWidth(range);
    value = app.getValue('view', 'size');
    $g('.slideshow-size-select input[type="hidden"]').val(value);
    value = $g('.slideshow-size-select li[data-value="'+value+'"]').text().trim();
    $g('.slideshow-size-select input[readonly]').val(value);
    value = app.getValue('view', 'arrows');
    $g('#slideshow-settings-dialog [data-group="view"][data-option="arrows"]')[0].checked = value;
    $g('#slideshow-settings-dialog .class-suffix').val(app.edit.suffix);
    value = app.getValue('margin', 'top');
    $g('#slideshow-settings-dialog [data-group="margin"][data-option="top"]').val(value);
    value = app.getValue('margin', 'bottom');
    $g('#slideshow-settings-dialog [data-group="margin"][data-option="bottom"]').val(value);
    setDisableState('#slideshow-settings-dialog');
    $g('#slideshow-settings-dialog .slideshow-style-custom-select input[type="hidden"]').val('title');
    $g('#slideshow-settings-dialog .slideshow-style-custom-select input[readonly]').val(gridboxLanguage['TITLE']);
    $g('#slideshow-settings-dialog .select-title-html-tag input[type="hidden"]').val(app.edit.tag);
    $g('#slideshow-settings-dialog .select-title-html-tag input[readonly]').val(app.edit.tag.toUpperCase());
    showSlideshowDesign('title', $g('#slideshow-settings-dialog .slideshow-style-custom-select'));
    $g('#slideshow-settings-dialog').attr('data-edit', app.edit.type);
    setTimeout(function(){
        $g('#slideshow-settings-dialog').modal();
    }, 150);
}

function setRecentPostsSliderLayout()
{
    if (app.edit.layout == 'carousel') {
        $g('#slideshow-settings-dialog')
            .find('input[data-option="count"], input[data-option="gutter"], input[data-option="overflow"]')
            .closest('.ba-settings-item').css('display', 'flex');
        $g('#slideshow-settings-dialog').find('input[data-option="fullscreen"], .slideshow-animation-select')
            .closest('.ba-settings-item').hide();
        $g('#slideshow-settings-dialog .slideset-caption-select').closest('.ba-settings-group').each(function(){
            $g(this).find('.carousel-options').css('display', 'flex');
            $g(this).find('.slideshow-options').hide();
        });
    } else {
        $g('#slideshow-settings-dialog')
            .find('input[data-option="count"], input[data-option="gutter"], input[data-option="overflow"]')
            .closest('.ba-settings-item').hide();
        $g('#slideshow-settings-dialog').find('input[data-option="fullscreen"], .slideshow-animation-select')
            .closest('.ba-settings-item').css('display', 'flex');
        $g('#slideshow-settings-dialog .slideset-caption-select').closest('.ba-settings-group').each(function(){
            $g(this).find('.carousel-options').hide();
            $g(this).find('.slideshow-options').css('display', 'flex');
        });
    }
}

$g('label[data-option]').on('mousedown', function(){
    var position = app.getValue('thumbnails', 'align');
    app.editor.$g(app.selector+' .ba-slideshow-dots').removeClass(position);
    app.edit.desktop.thumbnails.align = this.dataset.value;
    app.editor.$g(app.selector+' .ba-slideshow-dots').addClass(this.dataset.value);
});

$g('#slideshow-settings-dialog input[data-option="popup"]').on('change', function(){
    app.edit.popup = this.checked;
    var method = this.checked ? 'addClass' : 'removeClass';
    app.editor.$g(app.selector+' .slideshow-content')[method]('lightbox-enabled');
    app.addHistory();
});

$g('#slideshow-settings-dialog .recent-posts-layout-select').on('customAction', function(){
    var ul = app.editor.$g(app.selector).find('ul');
    app.edit.layout = this.querySelector('input[type="hidden"]').value;
    setRecentPostsSliderLayout();
    if (app.edit.layout == 'carousel') {
        app.editor.$g(app.selector).find('ul.ba-slideset')[0].className = 'ba-slideset carousel-type '+
            app.edit.desktop.caption.hover+' '+app.edit.desktop.caption.position;
        app.edit.desktop.caption.position = '';
        app.edit.desktop.caption.hover = '';
        app.edit.overflow = 'overflow';
    } else {
        app.editor.$g(app.selector).find('ul.ba-slideset')[0].className = 'ba-slideset slideshow-type '+app.edit.animation;
        app.edit.desktop.view.fullscreen = false;
        app.edit.desktop.view.height = 650;
        app.edit.desktop.caption.position = '';
        app.edit.desktop.caption.hover = '';
    }
    if (!app.edit.preset && !app.editor.app.theme.defaultPresets[app.edit.type]) {
        var type = app.edit.type,
            patern = $g.extend(true, {}, presetsPatern[type]),
            is_object = null,
            object = defaultElementsStyle[type];
        for (var ind in patern) {
            if (ind == 'desktop') {
                for (var key in patern[ind]) {
                    is_object = typeof(app.edit[ind][key]) == 'object';
                    app.edit[ind][key] = is_object ? $g.extend(true, {}, object[ind][key]) : object[ind][key];
                }
                for (var ind in app.editor.breakpoints) {
                    if (app.edit[ind]) {
                        for (var key in patern.desktop) {
                            is_object = typeof(app.edit[ind][key]) == 'object';
                            if (is_object && object[ind] && object[ind][key]) {
                                app.edit[ind][key] = $g.extend(true, {}, object[ind][key]);
                            } else if (!is_object && object[ind] && object[ind][key]) {
                                app.edit[ind][key] = object[ind][key];
                            } else if (is_object) {
                                app.edit[ind][key] = {};
                            } else {
                                delete(app.edit[ind][key]);
                            }
                        }
                    }
                }
            } else {
                is_object = typeof(app.edit[ind]) == 'object';
                app.edit[ind] = is_object ? $g.extend(true, {}, object[ind]) : object[ind];
            }
        }
        var view = $g.extend(true, {}, object.desktop.view);
        if (app.edit.layout != 'carousel') {
            view.button = true;
            view.height = 650;
            app.edit.desktop.title.typography.color = '@title-inverse';
            app.edit.desktop.title.typography['font-size'] = 56;
            app.edit.desktop.title.typography['line-height'] = 65;
            app.edit.desktop.title.typography['font-weight'] = '700';
            app.edit.desktop.title.typography['text-align'] = 'center';
            app.edit.desktop.info.typography.color = '@title-inverse';
            app.edit.desktop.info.typography['text-align'] = 'center';
            app.edit.desktop.intro.typography.color = '@title-inverse';
            app.edit.desktop.intro.typography['font-size'] = 24;
            app.edit.desktop.intro.typography['text-align'] = 'center';
            app.edit.desktop.button.typography['text-align'] = 'center';
            app.edit.desktop.overlay.color = '@overlay';
        }
        app.edit.desktop.view = $g.extend(true, app.edit.desktop.view, view);
        app.editor.app.checkModule('editItem');
        app.editor.app.setNewFont = true;
        app.editor.app.fonts = {};
        app.editor.app.customFonts = {};
    }
    var object = {
        data : app.edit,
        selector : app.editor.app.edit
    };
    app.editor.app.checkModule('initslideset', object);
    app.sectionRules();
    app.addHistory();
});

function getRecentPostsSlider()
{
    var category = new Array();
    for (var key in app.edit.categories) {
        category.push(key);
    }
    category = category.join(',');
    $g.ajax({
        type: "POST",
        dataType: 'text',
        url: "index.php?option=com_gridbox&task=editor.getRecentPostsSlider&tmpl=component",
        data: {
            id : app.edit.app,
            limit : app.edit.limit,
            sorting : app.edit.sorting,
            category : category,
            maximum : app.edit.maximum,
            featured: Number(app.edit.featured)
        },
        complete: function(msg){
            app.editor.document.querySelector(app.selector+' .slideshow-content').innerHTML = msg.responseText;
            app.editor.app.buttonsPrevent();
            var object = {
                data : app.edit,
                selector : app.editor.app.edit
            };
            app.editor.app.checkModule('initslideset', object);
            app.addHistory();
        }
    });
}

$g('.slideset-caption-select').on('customAction', function(){
    var value = $g(this).find('input[type="hidden"]').val();
    app.edit.desktop.caption.position = value;
    if (app.edit.desktop.caption.position == '') {
        $g('#slideshow-settings-dialog [data-option="hover"][data-group="caption"]').closest('.ba-settings-item').hide();
    } else {
        $g('#slideshow-settings-dialog [data-option="hover"][data-group="caption"]').closest('.ba-settings-item').css({
            display: ''
        });
    }
    if (!app.edit.preset && !app.editor.app.theme.defaultPresets[app.edit.type]) {
        var type = app.edit.type,
            patern = $g.extend(true, {}, presetsPatern[type]),
            is_object = null,
            theme = app.editor.app.theme,
            object = defaultElementsStyle[type];
        for (var ind in patern) {
            if (ind == 'desktop') {
                for (var key in patern[ind]) {
                    is_object = typeof(app.edit[ind][key]) == 'object';
                    app.edit[ind][key] = is_object ? $g.extend(true, {}, object[ind][key]) : object[ind][key];
                }
                for (var ind in app.editor.breakpoints) {
                    if (app.edit[ind]) {
                        for (var key in patern.desktop) {
                            is_object = typeof(app.edit[ind][key]) == 'object';
                            if (is_object && object[ind] && object[ind][key]) {
                                app.edit[ind][key] = $g.extend(true, {}, object[ind][key]);
                            } else if (!is_object && object[ind] && object[ind][key]) {
                                app.edit[ind][key] = object[ind][key];
                            } else if (is_object) {
                                app.edit[ind][key] = {};
                            } else {
                                delete(app.edit[ind][key]);
                            }
                        }
                    }
                }
            } else {
                is_object = typeof(app.edit[ind]) == 'object';
                app.edit[ind] = is_object ? $g.extend(true, {}, object[ind]) : object[ind];
            }
        }
        if (app.edit.type != 'recent-posts-slider' && app.edit.desktop.caption.position == '') {
            app.edit.desktop.overlay.color = '@bg-secondary';
            app.edit.desktop.description.typography.color = '@text';
            app.edit.desktop.title.typography.color = '@text';
            app.edit.desktop.title.typography['font-size'] = 20;
            app.edit.desktop.title.typography['line-height'] = 30;
        } else if (app.edit.type == 'recent-posts-slider') {
            var view = $g.extend(true, {}, object.desktop.view);
            if (app.edit.desktop.caption.position != '') {
                view.height = 400;
                app.edit.desktop.overlay.color = '@overlay';
                app.edit.desktop.title.typography.color = '@title-inverse';
                app.edit.desktop.title.typography['font-size'] = 24;
                app.edit.desktop.title.typography['line-height'] = 34;
                app.edit.desktop.title.margin.top = 200;
                app.edit.desktop.title.margin.bottom = 25;
                app.edit.desktop.info.typography.color = '@title-inverse';
                app.edit.desktop.intro.typography.color = '@title-inverse';
            }
            app.edit.desktop.view = $g.extend(true, app.edit.desktop.view, view);
        }
        app.editor.app.checkModule('editItem');
        app.editor.app.setNewFont = true;
        app.editor.app.fonts = {};
        app.editor.app.customFonts = {};
    }
    app.sectionRules();
    var object = {
        data : app.edit,
        selector : app.editor.app.edit
    };
    app.editor.app.checkModule('initslideset', object);
    app.addHistory();
});

$g('#slideshow-settings-dialog [data-option="hover"][data-group="caption"]').on('change', function(){
    var item = app.editor.document.querySelector(app.selector+' ul');
    if (this.checked) {
        app.edit.desktop.caption.hover = 'caption-hover';
    } else {
        app.edit.desktop.caption.hover = '';
    }
    app.sectionRules();
    setTimeout(function(){
        var object = {
            data : app.edit,
            selector : app.editor.app.edit
        };
        app.editor.app.checkModule('initslideset', object);
    }, 300);
    app.addHistory();
});

$g('.slideshow-item-effect-select').on('customAction', function(){
    var $this = $g(this).find('input[type="hidden"]')[0],
        value = $this.value,
        option = $this.dataset.option,
        group = $this.dataset.group,
        subgroup = $this.dataset.subgroup,
        items = app.editor.document.querySelectorAll(app.selector+' .ba-slideshow-'+group);
    if (group == 'button') {
        items = app.editor.document.querySelectorAll(app.selector+' .slideshow-button a');
    }
    if (app.edit.desktop[group][subgroup][option]) {
        for (var i = 0; i < items.length; i ++) {
            items[i].classList.remove(app.edit.desktop[group][subgroup][option]);
        }
    }
    app.edit.desktop[group][subgroup][option] = value;
    if (app.edit.desktop[group][subgroup][option]) {
        for (var i = 0; i < items.length; i ++) {
            items[i].classList.add(app.edit.desktop[group][subgroup][option]);
        }
    }
    app.addHistory();
});

$g('.slideshow-animation-select').on('customAction', function(){
    var value = $g(this).find('input[type="hidden"]').val(),
        item = app.editor.document.querySelector(app.selector+' ul');
    item.classList.remove(app.edit.animation);
    app.edit.animation = value;
    item.classList.add(app.edit.animation);
    app.addHistory();
});

$g('#slideshow-settings-dialog [data-group="slideshow"]').on('change input', function(){
    var option = this.dataset.option,
        value = this.value;
    if (this.type == 'checkbox') {
        value = this.checked;
    }
    app.setValue(value, 'slideshow', option);
    app.editor.app.initslideshow(app.edit, app.editor.app.edit);
    clearTimeout(delay);
    delay = setTimeout(function(){
        app.addHistory();
    }, 300);
});

$g('#slideshow-settings-dialog [data-group="slideset"]').on('change input', function(){
    var option = this.dataset.option,
        value = this.value;
    if (this.type == 'checkbox') {
        value = this.checked;
    }
    app.setValue(value, 'slideset', option);
    var object = {
        data : app.edit,
        selector : app.editor.app.edit
    }
    app.sectionRules();
    app.editor.app.checkModule('initItems', object);
    delay = setTimeout(function(){
        app.addHistory();
    }, 300);
});

$g('#slideshow-settings-dialog [data-option="gutter"]').on('change', function(){
    app.setValue(this.checked, 'gutter');
    app.editor.$g('.ba-item-'+app.edit.type).each(function(){
        if (app.editor.app.items[this.id]) {
            var obj = {
                data : app.editor.app.items[this.id],
                selector : this.id
            };
            app.editor.itemsInit.push(obj);
        }
    });
    if (app.editor.itemsInit.length > 0) {
        app.editor.app.checkModule('initItems', app.editor.itemsInit.pop());
    }
    app.sectionRules();
    app.addHistory();
});

$g('#slideshow-settings-dialog .add-new-item i').on('click', function(){
    uploadMode = 'addNewSlides';
    checkIframe($g('#uploader-modal').attr('data-check', 'multiple'), 'uploader');
    return false;
});

$g('#slideshow-settings-dialog .sorting-container').on('click', 'i.zmdi.zmdi-edit', function(){
    var key = $g(this).closest('.sorting-item').attr('data-key'),
        obj = $g.extend({}, sortingList[key]),
        value = 'image',
        video = {
            type : 'youtube',
            id : '',
            mute : true,
            start : 0,
            quality : 'hd720'
        },
        slides = app.getValue('slides'),
        object = slides[obj.index];
    if (object.video && app.view == 'desktop') {
        value = 'video';
        video = object.video;
    }
    if (video.type == 'source') {
        $g('#slideshow-item-dialog .video-source-select').css('display', '');
        $g('#slideshow-item-dialog .video-id').hide();
    } else {
        $g('#slideshow-item-dialog .video-source-select').hide();
        $g('#slideshow-item-dialog .video-id').css('display', '');
    }
    if (!video.source) {
        video.source == '';
    }
    $g('#slideshow-item-dialog .video-options, #slideshow-item-dialog .image-options').hide();
    $g('#slideshow-item-dialog .'+value+'-options').show();
    $g('#slideshow-item-dialog .slide-type-select input[type="hidden"]').val(value);
    value = $g('#slideshow-item-dialog .slide-type-select li[data-value="'+value+'"]').text().trim();
    $g('#slideshow-item-dialog .slide-type-select input[readonly]').val(value);
    $g('#slideshow-item-dialog .slide-image').val(object.image);
    $g('#slideshow-item-dialog .video-select input[type="hidden"]').val(video.type);
    value = $g('#slideshow-item-dialog .video-select li[data-value="'+video.type+'"]').text().trim();
    $g('#slideshow-item-dialog .video-select input[readonly]').val(value);
    $g('#slideshow-item-dialog .slide-video-id').val(video.id);
    $g('#slideshow-item-dialog .video-source-select input').val(video.source);
    $g('#slideshow-item-dialog .slide-video-start').val(video.start);
    $g('#slideshow-item-dialog .slide-video-mute').prop('checked', video.mute);
    $g('#slideshow-item-dialog .youtube-quality input[type="hidden"]').val(video.quality);
    value = $g('#slideshow-item-dialog .youtube-quality li[data-value="'+video.quality+'"]').text().trim();
    $g('#slideshow-item-dialog .youtube-quality input[readonly]').val(value);
    $g('#slideshow-item-dialog .slide-title').val(obj.title);
    $g('#slideshow-item-dialog .slide-description').val(obj.description);
    if (obj.button.type.indexOf('ba-overlay-slideshow-button') != -1) {
        value = 'link';
        $g('#slideshow-item-dialog .slideshow-button-label').hide();
    } else {
        value = 'button';
        $g('#slideshow-item-dialog .slideshow-button-label').show();
    }
    $g('#slideshow-item-dialog .slide-button-type-select input[type="hidden"]').val(value);
    value = $g('#slideshow-item-dialog .slide-button-type-select li[data-value="'+value+'"]').text().trim();
    $g('#slideshow-item-dialog .slide-button-type-select input[readonly]').val(value);
    $g('#slideshow-item-dialog').find('.slide-button-link').val(obj.button.href);
    $g('#slideshow-item-dialog').find('.slide-button-label').val(obj.button.title);
    $g('#slideshow-item-dialog').find('.slide-button-embed-code').val(obj.button.embed);
    $g('#slideshow-item-dialog .slide-button-target-select input[type="hidden"]').val(obj.button.target);
    value = $g('#slideshow-item-dialog .slide-button-target-select li[data-value="'+obj.button.target+'"]').text().trim();
    $g('#slideshow-item-dialog .slide-button-target-select input[readonly]').val(value);
    if (obj.button.download == null) {
        obj.button.download = '';
    }
    $g('#slideshow-item-dialog .slide-button-attribute-select input[type="hidden"]').val(obj.button.download);
    value = $g('#slideshow-item-dialog .slide-button-attribute-select li[data-value="'+obj.button.download+'"]').text().trim();
    $g('#slideshow-item-dialog .slide-button-attribute-select input[readonly]').val(value);
    $g('#apply-new-slide').removeClass('disable-button').addClass('active-button').attr('data-edit', key);
    if (app.edit.type != 'slideshow') {
        $g('.slideshow-slide-select').hide();
    } else {
        $g('.slideshow-slide-select')[0].style.display = '';
    }
    $g('#slideshow-item-dialog').modal();
});

$g('#slideshow-settings-dialog .sorting-container').on('click', 'i.zmdi.zmdi-copy', function(){
    var key = $g(this).closest('.sorting-item').attr('data-key') * 1,
        image = app.editor.$g(app.selector+' .slideshow-content > li').get(key),
        clone = image.cloneNode(true),
        obj = $g.extend({}, app.edit.desktop.slides[key + 1]),
        slides = {};
    key += 1;
    $g(image).after(clone);
    app.editor.app.buttonsPrevent();
    for (var ind in app.edit.desktop.slides) {
        if (ind == key) {
            slides[ind] = app.edit.desktop.slides[ind];
            slides[key + 1] = obj;
        } else if (ind >= key + 1) {
            slides[ind * 1 + 1] = app.edit.desktop.slides[ind];
        } else {
            slides[ind] = app.edit.desktop.slides[ind];
        }
    }
    app.edit.desktop.slides = slides;
    for (var point in app.editor.breakpoints) {
        if (app.edit[point] && app.edit[point].slides) {
            slides = {};
            for (var ind in app.edit[point].slides) {
                if (ind == key) {
                    slides[ind] = app.edit[point].slides[ind];
                    slides[key + 1] = obj;
                } else if (ind >= key + 1) {
                    slides[ind * 1 + 1] = app.edit[point].slides[ind];
                } else {
                    slides[ind] = app.edit[point].slides[ind];
                }
            }
            app.edit[point].slides = slides;
        }
    }
    var li = app.editor.document.querySelectorAll('#'+app.editor.app.edit+' ul li.item'),
        value = app.getValue('slides');
    sortingList = [];
    $g('#slideshow-settings-dialog .sorting-container').html('');
    for (var i = 0; i < li.length; i++) {
        if (!value[i + 1]) {
            value[i + 1] = {
                image: "",
                type: "image",
                link: "",
                embed: "",
                video: null
            }
        }
        var slide = value[i + 1],
            img = li[i].querySelector('.ba-slideshow-img'),
            title = li[i].querySelector('.ba-slideshow-title').textContent,
            description = li[i].querySelector('.ba-slideshow-description').innerHTML,
            button = li[i].querySelector('.ba-btn-transition'),
            obj = {
                index : i + 1,
                title : title,
                description : description,
                image : slide.image,
                type : slide.type,
                video : slide.video,
                button : {
                    href : $g(button).attr('href'),
                    embed: '',
                    type : button.className,
                    title : button.textContent,
                    download: button.getAttribute('download'),
                    target : button.target
                }
            }
        if (typeof(value[i + 1].link) != 'undefined') {
            obj.button.href = value[i + 1].link;
        }
        if (typeof(value[i + 1].embed) != 'undefined') {
            obj.button.embed = value[i + 1].embed;
        }
        if (app.view != 'desktop') {
            obj.type = 'image';
        }
        sortingList.push(obj);
        $g('#slideshow-settings-dialog .sorting-container').append(addSlideSortingList(obj, i));
        $g('#slideshow-settings-dialog .slideshow-size-select').parent().css('display', '');
    }
    var object = {
        data : app.edit,
        selector : app.editor.app.edit
    }
    app.editor.app.checkModule('initItems', object);
    app.sectionRules();
    app.addHistory();
})

$g('#slideshow-item-dialog').find('.slide-image').on('click', function(){
    fontBtn = this;
    uploadMode = 'slideImage';
    checkIframe($g('#uploader-modal').attr('data-check', 'single'), 'uploader');
});

$g('#slideshow-item-dialog').find('.slide-image, .slide-video-id').on('input', function(){
    if (this.value.trim()) {
        $g('#apply-new-slide').removeClass('disable-button').addClass('active-button');
    } else {
        $g('#apply-new-slide').addClass('disable-button').removeClass('active-button');
    }
});

$g('#slideshow-settings-dialog .sorting-container').on('click', '.zmdi.zmdi-delete', function(){
    app.itemDelete = $g(this).closest('.sorting-item').attr('data-key');
    app.checkModule('deleteItem');
});

$g('#slideshow-item-dialog .slide-button-type-select').on('customAction', function(){
    var value = $g(this).find('input[type="hidden"]').val();
    if (value == 'button') {
        $g('#slideshow-item-dialog .slideshow-button-label').show();
    } else {
        $g('#slideshow-item-dialog .slideshow-button-label').hide();
    }
});

$g('#slideshow-item-dialog .slide-type-select').on('customAction', function(){
    var target = $g(this).find('input[type="hidden"]').val(),
        parent = $g('#slideshow-item-dialog .'+target+'-options');
    $g('#slideshow-item-dialog').find('.image-options, .video-options').hide();
    parent.show();
    parent.addClass('ba-active-options');
    setTimeout(function(){
        parent.removeClass('ba-active-options');
    }, 1);
    $g('#slideshow-item-dialog .video-source-select').hide();
    $g('#slideshow-item-dialog').find('.slide-image, .slide-video-id, .video-source-select input').val('');
    $g('#apply-new-slide').addClass('disable-button').removeClass('active-button');
});

$g('#apply-new-slide').on('click', function(){
    if (!this.classList.contains('active-button')) {
        return false;
    }
    var modal = $g('#slideshow-item-dialog'),
        obj = {
            image : modal.find('.slide-image').val(),
            type : modal.find('.slide-type-select input[type="hidden"]').val(),
            video : {
                type : modal.find('.video-select input[type="hidden"]').val(),
                id : modal.find('.slide-video-id').val().trim(),
                source: modal.find('.video-source-select input').val().trim(),
                mute : modal.find('.slide-video-mute')[0].checked,
                start : modal.find('.slide-video-start').val().trim(),
                quality : modal.find('.youtube-quality input[type="hidden"]').val()
            },
            title : modal.find('.slide-title').val().trim(),
            description : modal.find('.slide-description').val().trim(),
            button : {
                href : modal.find('.slide-button-link').val().trim(),
                embed : modal.find('.slide-button-embed-code').val().trim(),
                type : modal.find('.slide-button-type-select input[type="hidden"]').val(),
                title : modal.find('.slide-button-label').val().trim(),
                target : modal.find('.slide-button-target-select input[type="hidden"]').val(),
                download : modal.find('.slide-button-attribute-select input[type="hidden"]').val()
            }
        };
    if (obj.type == 'image') {
        obj.video = null;
    }
    if (obj.button.type == 'button') {
        obj.button.type = 'ba-btn-transition';
    } else {
        obj.button.type = 'ba-btn-transition ba-overlay-slideshow-button';
    }
    var str = getSlideHtml(obj),
        key = this.dataset.edit,
        item = $g('#slideshow-settings-dialog .sorting-container .sorting-item[data-key="'+key+'"]'),
        div;
    obj.index = sortingList[key].index;
    sortingList[key] = obj;
    item.replaceWith(addSlideSortingList(obj, key));
    $g('#slideshow-settings-dialog .sorting-container .sorting-item').each(function(ind){
        if (this.dataset.key == key) {
            if (!app.edit[app.view].slides) {
                app.edit[app.view].slides = {};
            }
            app.edit.desktop.slides[ind + 1].link = obj.button.href;
            app.edit.desktop.slides[ind + 1].embed = obj.button.embed;
            app.edit[app.view].slides[ind + 1] = {
                image : obj.image,
                type : obj.type,
                link : obj.button.href,
                embed : obj.button.embed,
                video : obj.video
            }
            div = app.editor.document.querySelector('#'+app.editor.app.edit+' .slideshow-content > li:nth-child('+(ind + 1)+')');
            $g(div).replaceWith(str);
            if (obj.button.embed) {
                var a = app.editor.$g('#'+app.editor.app.edit+' .slideshow-content > li:nth-child('+(ind + 1)+') .slideshow-button a');
                replaceSlideEmbed(a, obj.button);
            }
            return false;
        }
    });
    app.editor.app.buttonsPrevent();
    var object = {
        data : app.edit,
        selector : app.editor.app.edit
    }
    app.editor.app.checkModule('initItems', object);
    app.sectionRules();
    app.addHistory();
    modal.modal('hide');
});

$g('#slideshow-settings-dialog .slideshow-navigation-select').on('customAction', function(){
    app.editor.$g(app.selector+' .ba-slideshow-dots').removeClass(app.edit.dots.layout);
    app.edit.dots.layout = this.querySelector('input[type="hidden"]').value;
    app.editor.$g(app.selector+' .ba-slideshow-dots').addClass(app.edit.dots.layout);
	if (app.edit.dots.layout != 'thumbnails-dots') {
    	$g('#slideshow-settings-dialog [data-group="thumbnails"]').closest('.ba-settings-item').hide();
    } else {
    	$g('#slideshow-settings-dialog [data-group="thumbnails"]').closest('.ba-settings-item').css('display', '');
    }
    app.sectionRules();
    var object = {
        data : app.edit,
        selector : app.editor.app.edit
    };
    app.editor.app.checkModule('initslideshow', object);
    app.addHistory();
});

$g('#slideshow-settings-dialog input[data-option="outside"]').on('change', function(){
    app.edit.dots.outside = this.checked ? 'dots-position-outside' : '';
    if (this.checked) {
        app.editor.$g(app.selector+' .ba-slideshow-dots').addClass('dots-position-outside');
    } else {
        app.editor.$g(app.selector+' .ba-slideshow-dots').removeClass('dots-position-outside');
    }
    var object = {
        data : app.edit,
        selector : app.editor.app.edit
    };
    app.editor.app.checkModule('initslideshow', object);
    app.addHistory();
});

function replaceSlideEmbed(a, obj)
{
    var str = '<a class="'+obj.type+'" target="'+obj.target+'" href="'+obj.href+'"';
    if (obj.download) {
        str += ' download';
    }
    str += ' '+obj.embed;
    str += '>'+obj.title+'</a>';
    var div = document.createElement(div);
    div.innerHTML = str;
    if (div.querySelector('a')) {
        a.replaceWith(div.querySelector('a'));
    }
}

if (!app.modules.draggable) {
    app.loadModule('draggable');
}
if (!app.modules.resizable) {
    app.loadModule('resizable');
}

app.modules.slideshowEditor = true;
app.slideshowEditor();