<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die; 

jimport('joomla.application.component.modeladmin');
jimport('joomla.filesystem.file');

class gridboxModelTheme extends JModelAdmin
{
    public function getTable($type = 'Style', $prefix = 'TemplatesTable', $config = array())
    {
        return JTable::getInstance($type, $prefix, $config);
    }

    public function addNewTheme($xml)
    {
        $themes = array();
        $main_menu = array();
        $modules_menu = array();
        $deeper = array();
        $pages = array();
        $forms = array();
        $appsList = array(0 => 0);
        $catsList = array(0 => 0, 'trashed' => 'trashed');
        $baforms_items = array();
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select('COUNT(extension_id)')
            ->from("#__extensions")
            ->where('element = '.$db->quote('com_baforms'));
        $db->setQuery($query);
        $result = $db->loadResult();
        if ($result > 0 && isset($xml->com_baforms)) {
            foreach ($xml->com_baforms->baform as $key => $baform) {
                $form = json_decode($baform->forms);
                if (empty($form)) {
                   continue;
                }
                $items = json_decode($baform->items);
                $columns = json_decode($baform->columns);
                $fId = $form->id;
                $form->id = 0;
                $db->insertObject('#__baforms_forms', $form);
                $forms[$fId] = $db->insertid();
                foreach ($items as $item) {
                    $iId = $item->id;
                    $item->id = 0;
                    $item->form_id = $forms[$fId];
                    $db->insertObject('#__baforms_items', $item);
                    $baforms_items[$iId] = $db->insertid();
                }
                foreach ($columns as $column) {
                    $column->id = 0;
                    $column->form_id = $forms[$fId];
                    $db->insertObject('#__baforms_columns', $column);
                }
                $query = $db->getQuery(true)
                    ->select('email_letter, reply_body')
                    ->from('#__baforms_forms')
                    ->where('`id` = '.$forms[$fId]);
                $db->setQuery($query);
                $letter = $db->loadObject();
                $regex = '/\[item=+(.*?)\]/i';
                preg_match_all($regex, $letter->email_letter, $matches, PREG_SET_ORDER);
                foreach ($matches as $match) {
                    $iId = $match[1];
                    $letter->email_letter = str_replace('[item='.$iId.']', '[item='.$baforms_items[$iId].']', $letter->email_letter);
                }
                $regex = '/\[field ID=+(.*?)\]/i';
                preg_match_all($regex, $letter->reply_body, $matches, PREG_SET_ORDER);
                foreach ($matches as $match) {
                    $iId = $match[1];
                    $letter->reply_body = str_replace('[field ID='.$iId.']', '[field ID='.$baforms_items[$iId].']', $letter->reply_body);
                }
                $form->id = $forms[$fId];
                $form->email_letter = $letter->email_letter;
                $form->reply_body = $letter->reply_body;
                $db->updateObject('#__baforms_forms', $form, 'id');
            }
        }
        foreach ($xml->mainmenu->main_menu as $mainmenu) {
            $module = json_decode($mainmenu->module);
            $module_menu = json_decode($mainmenu->module_menu);
            $asset = json_decode($mainmenu->asset);
            $menu = json_decode($mainmenu->menu);
            $menu->menutype = $this->getNewMenuType($menu->menutype, '');
            $menu->id = 0;
            $menu_items = json_decode($mainmenu->menu_items);
            $modules_menu[$module->id] = '';
            $query = $db->getQuery(true);
            $query->select("extension_id");
            $query->from("#__extensions");
            $query->where("type=" .$db->quote('component'))
                ->where('element=' .$db->quote('com_gridbox'));
            $db->setQuery($query);
            $com_id = $db->loadResult();
            $query = $db->getQuery(true);
            $query->select('id')
                ->from('#__assets')
                ->where('`name` = ' .$db->quote('com_modules'));
            $db->setQuery($query);
            if (!$asset) {
                $asset = new stdClass();
            }
            $asset->parent_id = $db->loadResult();
            $old_id = $module->id;
            $module->id = 0;
            $module->params = json_decode($module->params);
            $module->params->menutype = $menu->menutype;
            $module->params = json_encode($module->params);
            $table = JTable::getInstance('Module', 'JTable', array());
            $data = array();
            foreach ($module as $key => $value) {
                if ($key != 'asset_id') {
                    $data[$key] = $value;
                }
            }
            JPluginHelper::importPlugin($this->events_map['save']);
            $table->bind($data);
            $table->check();
            $dispatcher = JEventDispatcher::getInstance();
            $dispatcher->trigger('onExtensionBeforeSave', array('com_modules.module', &$table, true));
            $table->store();
            $dispatcher->trigger('onExtensionAfterSave', array('com_modules.module', &$table, true));
            $mod_id = $table->id;
            $modules_menu[$old_id] = $mod_id;
            $module_menu->moduleid = $mod_id;
            $query = $db->getQuery(true);
            $query->select('COUNT(moduleid)')
                ->where('`moduleid` = '.$mod_id)
                ->from('`#__modules_menu`');
            $db->setQuery($query);
            $c = $db->loadResult();
            if (empty($c)) {
                $db->insertObject('#__modules_menu', $module_menu);
            }
            $db->insertObject('#__menu_types', $menu);
            foreach ($menu_items as $item) {
                if ($item->published == 1 || $item->published == 0) {
                    $id = $item->id;
                    $item->id = 0;
                    $item->menutype = $menu->menutype;
                    $item->component_id = $com_id;
                    $item->template_style_id = 0;
                    $item->home = 0;
                    $menu_table = $this->getTable($type = 'Menu', $prefix = 'gridboxTable', array());
                    $array = array('menutype' => $menu->menutype, 'title' => $item->title,
                                    'path' => $item->path, 'link' => $item->link, 'type' => $item->type,
                                    'level' => $item->level,
                                    'component_id' => $com_id, 'access' => $item->access,
                                    'template_style_id' => 0, 'language' => '*', 'params' => $item->params,
                                    'alias' => $this->getNewMenuAlias($item->alias, ''));
                    $menu_table->bind($array);
                    $menu_table->store();
                    $obj = new stdClass();
                    $obj->id = $menu_table->id;
                    $obj->level = $item->level;
                    $obj->published = $item->published;
                    $db->updateObject('#__menu', $obj, 'id');
                    $main_menu[$id] = $menu_table->id;
                    if ($item->parent_id > 1) {
                        $deeper[$menu_table->id] = $item->parent_id;
                        $obj = new stdClass();
                        $obj->id = $menu_table->id;
                        $obj->lft = $item->lft;
                        $obj->rgt = $item->rgt;
                        $db->updateObject('#__menu', $obj, 'id');
                    } else {
                        $obj = new stdClass();
                        $obj->id = $menu_table->id;
                        $obj->parent_id = 1;
                        $obj->lft = $item->lft;
                        $obj->rgt = $item->rgt;
                        $db->updateObject('#__menu', $obj, 'id');
                    }
                }                
            }
            foreach ($deeper as $key => $deep) {
                $obj = new stdClass();
                $obj->id = $key;
                $obj->parent_id = $main_menu[$deep];
                $db->updateObject('#__menu', $obj, 'id');
            }
        }
        foreach ($xml->themes->theme as $theme) {
            $table = $this->getTable();
            $params = json_decode((string)$theme->params);
            $obj = $this->checkMainMenu($params->header->html, $params->header->items, $modules_menu);
            $obj = $this->checkBaforms($obj->html, $obj->items, $forms);
            $params->header->html = $obj->html;
            $params->header->items = $obj->items;
            $obj = $this->checkMainMenu($params->footer->html, $params->footer->items, $modules_menu);
            $obj = $this->checkBaforms($obj->html, $obj->items, $forms);
            $params->footer->html = $obj->html;
            $params->footer->items = $obj->items;
            $theme->params = json_encode($params);
            $table->bind(array('title' => (string)$theme->title, 'params' => (string)$theme->params,
                'home' => 0, 'client_id' => 0, 'template' => 'gridbox'));
            $table->store();
            $themes[(string)$theme->id] = $table->id;
            gridboxHelper::saveCodeEditor($theme, $table->id);
        }
        if (isset($xml->apps)) {
            foreach ($xml->apps->app as $app) {
                $obj = json_decode($app);
                $id = $obj->id;
                $obj->theme = $themes[$obj->theme];
                $obj->alias = gridboxHelper::getAlias($obj->alias, '#__gridbox_app');
                unset($obj->id);
                $db->insertObject('#__gridbox_app', $obj);
                $appsList[$id] = $db->insertid();
            }
        }
        if (isset($xml->categories)) {
            $catsChild = array();
            foreach ($xml->categories->category as $category) {
                $obj = json_decode($category);
                $id = $obj->id;
                $obj->app_id = $appsList[$obj->app_id];
                $obj->alias = gridboxHelper::getAlias($obj->alias, '#__gridbox_categories');
                unset($obj->id);
                $db->insertObject('#__gridbox_categories', $obj);
                $catsList[$id] = $db->insertid();
                if ($obj->parent != 0) {
                    $object = new stdClass();
                    $object->id = $catsList[$id];
                    $object->parent = $obj->parent;
                    $catsChild[] = $object;
                }
            }
            foreach ($catsChild as $child) {
                $child->parent = $catsList[$child->parent];
                $db->updateObject('#__gridbox_categories', $child, 'id');
            }
        }
        foreach ($appsList as $value) {
            if (empty($value)) {
                continue;
            }
            $query = $db->getQuery(true)
                ->select('id, page_layout, page_items, app_layout, app_items')
                ->from('#__gridbox_app')
                ->where('id = '.$value);
            $db->setQuery($query);
            $obj = $db->loadObject();
            $object = new stdClass();
            $object->html = $obj->page_layout;
            $object->items = json_decode($obj->page_items);
            $object = gridboxHelper::importBlogContent($object, $appsList, $catsList);
            $obj->page_layout = $object->html;
            $obj->page_items = json_encode($object->items);
            $object = new stdClass();
            $object->html = $obj->app_layout;
            $object->items = json_decode($obj->app_items);
            $object = gridboxHelper::importBlogContent($object, $appsList, $catsList);
            $obj->app_layout = $object->html;
            $obj->app_items = json_encode($object->items);
            $db->updateObject('#__gridbox_app', $obj, 'id');
        }
        foreach ($themes as $value) {
            $query = $db->getQuery(true)
                ->select('id, params')
                ->from('#__template_styles')
                ->where('id = '.$value);
            $db->setQuery($query);
            $obj = $db->loadObject();
            $params = json_decode($obj->params);
            $object = new stdClass();
            $object->html = $params->header->html;
            $object->items = $params->header->items;
            $object = gridboxHelper::importBlogContent($object, $appsList, $catsList);
            $params->header->html = $object->html;
            $params->header->items = $object->items;
            $object = new stdClass();
            $object->html = $params->footer->html;
            $object->items = $params->footer->items;
            $object = gridboxHelper::importBlogContent($object, $appsList, $catsList);
            $params->footer->html = $object->html;
            $params->footer->items = $object->items;
            $obj->params = json_encode($params);
            $db->updateObject('#__template_styles', $obj, 'id');
        }

        foreach ($xml->pages->page as $page) {
            $obj = json_decode($page);
            $obj->style = json_decode($obj->style);            
            $params = $this->checkMainMenu($obj->params, $obj->style, $modules_menu);
            $params = $this->checkBaforms($params->html, $params->items, $forms);
            $params = gridboxHelper::importBlogContent($params, $appsList, $catsList);
            $obj->params = $params->html;
            $obj->style = $params->items;
            $obj->page_alias = gridboxHelper::getNewPageAlias($obj->page_alias, '');
            $id = $obj->id;
            $obj->theme = $themes[$obj->theme];
            $obj->style = json_encode($obj->style);
            $obj->app_id = $appsList[$obj->app_id];
            if (!empty($obj->page_category)) {
                $obj->page_category = $catsList[$obj->page_category];
            }
            unset($obj->id);
            $db->insertObject('#__gridbox_pages', $obj);
            $pages[$id] = $db->insertid();
        }
        if (isset($xml->tags)) {
            $tagsList = array();
            foreach ($xml->tags->tag as $tag) {
                $obj = json_decode($tag);
                $id = $obj->id;
                $object = new stdClass();
                $object->tag_id = $obj->tag_id;
                $object->page_id = $pages[$obj->page_id];
                unset($obj->tag_id);
                unset($obj->page_id);
                unset($obj->id);
                if (!in_array($id, $tagsList)) {
                    $query = $db->getQuery(true)
                        ->select('id')
                        ->from('#__gridbox_tags')
                        ->where('title = '.$db->quote($obj->title));
                    $db->setQuery($query);
                    $tagId = $db->loadResult();
                    if (empty($tagId)) {
                        $db->insertObject('#__gridbox_tags', $obj);
                        $tagsList[$id] = $db->insertid();
                    } else {
                        $tagsList[$id] = $tagId;
                    }
                }
                $object->tag_id = $tagsList[$object->tag_id];
                $db->insertObject('#__gridbox_tags_map', $object);
            }
        }
        foreach ($xml->libraries->library as $lib) {
            $obj = json_decode($lib);
            $query = $db->getQuery(true)
                ->select('id')
                ->from('#__gridbox_library')
                ->where('`global_item` = '.$db->quote($obj->global_item));
            $db->setQuery($query);
            $result = $db->loadResult();
            if (empty($result)) {
                unset($obj->id);
                $obj->item = json_decode($obj->item);
                $obj->item = $this->checkMainMenu($obj->item->html, $obj->item->items, $modules_menu);
                $obj->item = $this->checkBaforms($obj->item->html, $obj->item->items, $forms);
                $obj->item = json_encode($obj->item);
                $db->insertObject('#__gridbox_library', $obj);
            }
        }
        JFile::delete(JPATH_ROOT.'/templates/gridbox/css/storage/global-library.css');
        foreach ($main_menu as $key => $value) {
            $menu_table->load($value);
            $link = array();
            $url = substr($menu_table->link, strpos($menu_table->link, '?option') + 1);
            parse_str($url, $link);
            if ($link['view'] == 'page') {
                if (isset($pages[$link['id']])) {
                    $link['id'] = $pages[$link['id']];
                } else {
                    $link['id'] = end($pages);
                }
            } else {
                if (isset($catsList[$link['id']]) && isset($appsList[$link['app']])) {
                    $link['id'] = $catsList[$link['id']];
                    $link['app'] = $appsList[$link['app']];
                } else {
                    $link['id'] = 0;
                    $link['app'] = end($appsList);
                }
            }
            $array = array();
            foreach ($link as $key => $value) {
                $array[] = $key.'='.$value;
            }
            $url = implode('&', $array);
            $menu_table->bind(array('link' => 'index.php?'.$url));
            $menu_table->store();
        }
        $this->rebuild();
    }

    public function rebuild()
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $table = $this->getTable($type = 'Menu', $prefix = 'gridboxTable', array());
        try
        {
            $rebuildResult = $table->rebuild();
        }
        catch (Exception $e)
        {
            $this->setError($e->getMessage());

            return false;
        }
        if (!$rebuildResult) {
            $this->setError($table->getError());
            return false;
        }
        $query->select('id, params')
            ->from('#__menu')
            ->where('params NOT LIKE ' . $db->quote('{%'))
            ->where('params <> ' . $db->quote(''));
        $db->setQuery($query);
        try
        {
            $items = $db->loadObjectList();
        }
        catch (RuntimeException $e)
        {
            return JError::raiseWarning(500, $e->getMessage());
        }
        foreach ($items as &$item) {
            $registry = new Registry;
            $registry->loadString($item->params);
            $params = (string) $registry;
            $query->clear();
            $query->update('#__menu')
                ->set('params = ' . $db->quote($params))
                ->where('id = ' . $item->id);
            try
            {
                $db->setQuery($query)->execute();
            }
            catch (RuntimeException $e)
            {
                return JError::raiseWarning(500, $e->getMessage());
            }
            unset($registry);
        }
        $this->cleanCache();

        return true;
    }

    public function checkMainMenu($html, $items, $menu)
    {
        $obj = new stdClass();
        $obj->html = $html;
        $obj->items = $items;
        $regex = '/\[main_menu=+(.*?)\]/i';
        preg_match_all($regex, $obj->html, $matches, PREG_SET_ORDER);
        if (!empty($menu)) {
            foreach ($matches as $index => $match) {
                if (isset($menu[$match[1]])) {
                    $obj->html = str_replace("[main_menu=".$match[1]."]", "[main_menu=".$menu[$match[1]]."]", $obj->html);
                }
            }
            foreach ($obj->items as $key => $value) {
                if ($value->type == 'menu') {
                    if (isset($menu[$value->integration])) {
                        $value->integration = $menu[$value->integration];
                    }
                }
            }
        }

        return $obj;
    }

    public function checkBaforms($html, $items, $forms)
    {
        $obj = new stdClass();
        $obj->html = $html;
        $obj->items = $items;
        $regex = '/\[forms ID=+(.*?)\]/i';
        preg_match_all($regex, $obj->html, $matches, PREG_SET_ORDER);
        if (!empty($matches)) {
            foreach ($matches as $index => $match) {
                if (isset($forms[$match[1]])) {
                    $obj->html = str_replace('[forms ID='.$match[1].']', '[forms ID='.$forms[$match[1]].']', $obj->html);
                }
            }
            foreach ($obj->items as $key => $value) {
                if ($value->type == 'forms') {
                    if (isset($forms[$match[1]])) {
                        $value->integration = $forms[$value->integration];
                    }
                }
            }
        }

        return $obj;
    }

    public function getNewMenuType($type, $orig)
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('COUNT(id)')
            ->from('#__menu_types')
            ->where('`menutype` = '.$db->quote($type));
        $db->setQuery($query);
        $n = $db->loadResult();
        if (!empty($n)) {
            if (empty($orig)) {
                $type = JString::increment($type);
            } else {
                $type = JString::increment($orig);
            }
            $orig = $type;
            $type = gridboxHelper::stringURLSafe($type);
            if (empty($type)) {
                $type = $orig;
                $type = gridboxHelper::replace($type);
                $type = JFilterOutput::stringURLSafe($type);
            }
            if (empty($type)) {
                $type = date('Y-m-d-H-i-s');
            }
            $type = $this->getNewMenuType($type, $orig);
        }

        return $type;
    }

    public function getNewMenuAlias($type, $orig)
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('COUNT(id)')
            ->from('#__menu')
            ->where('`alias` = '.$db->quote($type));
        $db->setQuery($query);
        $n = $db->loadResult();
        if (!empty($n)) {
            if (empty($orig)) {
                $type = JString::increment($type);
            } else {
                $type = JString::increment($orig);
            }
            $orig = $type;
            $type = gridboxHelper::stringURLSafe($type);
            if (empty($type)) {
                $type = $orig;
                $type = gridboxHelper::replace($type);
                $type = JFilterOutput::stringURLSafe($type);
            }
            if (empty($type)) {
                $type = date('Y-m-d-H-i-s');
            }
            $type = $this->getNewMenuAlias($type, $orig);
        }
        return $type;
    }

    public function checkItems($cid)
    {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
            ->select('id')
            ->from('#__template_styles')
            ->where('`home` = 1')
            ->where('`client_id` = 0')
            ->where('`template` = '.$db->quote('gridbox'));
        $db->setQuery($query);
        $default= $db->loadResult();
        foreach ($cid as $id) {
            $query = $db->getQuery(true);
            $query->update('#__gridbox_app')
                ->set('`theme` = '.$default)
                ->where('`theme` = '.$id);
            $db->setQuery($query);
            $db->execute();
            $query = $db->getQuery(true);
            $query->update('#__gridbox_pages')
                ->set('`theme` = '.$default)
                ->where('`theme` = '.$id);
            $db->setQuery($query);
            $db->execute();
        }
    }

    public function updateParams()
    {
        $input = JFactory::getApplication()->input;
        $table = $this->getTable();
        $old = $input->get('old_default');
        $default = $input->get('default_theme');
        $id = $input->get('ba_id');
        $title = $_POST['theme_title'];
        $db = JFactory::getDbo();
        if ($old != $default) {
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $fields = array(
                $db->quoteName('home') . ' = 0'
            );
            $conditions = array(
                $db->quoteName('home') . ' = 1',
                $db->quoteName('client_id') . ' = 0',
            );
            $query->update($db->quoteName('#__template_styles'))
                ->set($fields)
                ->where($conditions);
            $db->setQuery($query)
                ->execute();
        }
        $query = $db->getQuery(true)
            ->select('params')
            ->from('#__template_styles')
            ->where('id = '.$id);
        $db->setQuery($query);
        $result = $db->loadResult();
        $obj = json_decode($result);
        $obj->image = $_POST['image'];
        $result = json_encode($obj);
        $table->load($id);
        $table->bind(array('title' => $title, 'home' => $default*1, 'params' => $result));
        $table->store();
        echo JText::_('JLIB_APPLICATION_SAVE_SUCCESS');
        exit;
    }

    public function sendHTTP()
    {
        $http = JHttpFactory::getHttp();
        $url = 'http://www.balbooa.com/demo/index.php?option=com_baupdater&task=gridbox.getThemeLicense';
        $data = array('login' => $_POST['username'], 'password' => $_POST['password'], 'theme_id' => $_POST['theme']);
        $response = $http->post($url, $data);
        $text = $response->body;
        if ($text[0].$text[1].$text[2].$text[3] != 'http') {
            $text = JText::_($text);
        }
        echo($text);
        exit;
    }

    public function cleanCache($group = null, $client_id = 0)
    {
        parent::cleanCache('com_modules');
        parent::cleanCache('mod_menu');
    }
    
    public function getForm($data = array(), $loadData = true)
    {
        $form = $this->loadForm(
            $this->option . '.gridbox', 'gridbox', array('control' => 'jform', 'load_data' => $loadData)
        );
        
        if (empty($form))
        {
            return false;
        }
 
        return $form;
    }
    
    protected function getNewTitle($title)
	{
        $table = $this->getTable();
        while ($table->load(array('title' => $title)))
		{
			$title = JString::increment($title);
		}

		return $title;
	}
    
    public function duplicate(&$pks)
    {
        $db = $this->getDbo();
        foreach ($pks as $pk) {
            $table = $this->getTable();
            $table->load($pk, true);
            $table->id = 0;
            $table->title = $this->getNewTitle($table->title);
            $table->home = 0;
            $table->store();
            gridboxHelper::copyThemeFiles($pk, $table->id);
        }
    }
}