/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

app.contentSliderEditor = function(){
    app.selector = '#'+app.editor.app.edit;
    $g('#content-slider-settings-dialog .active').removeClass('active');
    $g('#content-slider-settings-dialog a[href="#content-slider-general-options"]').parent().addClass('active');
    $g('#content-slider-general-options').addClass('active');
    var value;
    sortingList = [];
    $g('#content-slider-settings-dialog .sorting-container').html('');
    for (var ind in app.edit.slides) {
        var str = '<div class="sorting-item" data-key="'+ind+
            '"><div class="sorting-handle"><i class="zmdi zmdi-apps"></i></div><div class="sorting-title">'+
            app.edit.slides[ind].title+'</div><div class="sorting-icons"><span><i class="zmdi zmdi-edit"></i>'+
            '</span><span><i class="zmdi zmdi-delete"></i></span></div></div>';
        $g('#content-slider-settings-dialog .sorting-container').append(str);
        sortingList.push(app.edit.slides[ind]);
    }
    setPresetsList($g('#content-slider-settings-dialog'));
    $g('#content-slider-settings-dialog [data-group="slideset"]').each(function(){
        value = app.getValue('slideset', this.dataset.option);
        if (this.type == 'checkbox') {
            this.checked = value;
        } else {
            this.value = value;
        }
    });
    value = app.getValue('gutter');
    $g('#content-slider-settings-dialog [data-option="gutter"]').prop('checked', value);
    $g('.slideset-animation-select input[type="hidden"]').val(app.edit.animation);
    value = $g('.slideset-animation-select li[data-value="'+app.edit.animation+'"]').text();
    $g('.slideset-animation-select input[readonly]').val($g.trim(value));
    value = app.getValue('view', 'dots');
    $g('#content-slider-settings-dialog [data-group="view"][data-option="dots"]')[0].checked = value;
    $g('#content-slider-settings-dialog .section-access-select input[type="hidden"]').val(app.edit.access);
    value = $g('#content-slider-settings-dialog .section-access-select li[data-value="'+app.edit.access+'"]').text();
    $g('#content-slider-settings-dialog .section-access-select input[readonly]').val($g.trim(value));
    value = app.getValue('view', 'arrows');
    $g('#content-slider-settings-dialog [data-group="view"][data-option="arrows"]')[0].checked = value;
    $g('#content-slider-settings-dialog .class-suffix').val(app.edit.suffix);
    value = app.getValue('margin', 'top');
    $g('#content-slider-settings-dialog [data-group="margin"][data-option="top"]').val(value);
    value = app.getValue('margin', 'bottom');
    $g('#content-slider-settings-dialog [data-group="margin"][data-option="bottom"]').val(value);
    setDisableState('#content-slider-settings-dialog');
    $g('#content-slider-settings-dialog .slideshow-design-group input[type="hidden"]').val('arrows');
    $g('#content-slider-settings-dialog .slideshow-design-group input[readonly]').val(gridboxLanguage['ARROWS']);
    showSlideshowDesign('arrows', $g('#content-slider-settings-dialog .slideshow-style-custom-select'));
    $g('#content-slider-settings-dialog').attr('data-edit', app.edit.type);
    setTimeout(function(){
        $g('#content-slider-settings-dialog').modal();
    }, 150);
}

$g('#content-slider .slideset-animation-select').on('customAction', function(){
    var value = $g(this).find('input[type="hidden"]').val(),
        item = app.editor.document.querySelector(app.selector+' ul');
    item.classList.remove(app.edit.animation);
    app.edit.animation = value;
    item.classList.add(app.edit.animation);
    app.addHistory();
});

$g('#content-slider-settings-dialog [data-group="slideset"]').on('change input', function(){
    var option = this.dataset.option,
        value = this.value;
    if (this.type == 'checkbox') {
        value = this.checked;
    }
    app.setValue(value, 'slideset', option);
    var object = {
        data : app.edit,
        selector : app.editor.app.edit
    }
    app.sectionRules();
    app.editor.app.checkModule('initItems', object);
    delay = setTimeout(function(){
        app.addHistory();
    }, 300);
});

$g('#content-slider-settings-dialog [data-option="gutter"]').on('change', function(){
    app.setValue(this.checked, 'gutter');
    app.editor.$g('.ba-item-'+app.edit.type).each(function(){
        if (app.editor.app.items[this.id]) {
            var obj = {
                data : app.editor.app.items[this.id],
                selector : this.id
            };
            app.editor.itemsInit.push(obj);
        }
    });
    if (app.editor.itemsInit.length > 0) {
        app.editor.app.checkModule('initItems', app.editor.itemsInit.pop());
    }
    app.sectionRules();
    app.addHistory();
});

$g('#content-slider-settings-dialog .add-new-item i').on('click', function(){
    $g('.content-slider-item-title').val('');
    $g('#apply-content-slider-item').attr('data-action', 'new').removeClass('active-button').addClass('disable-button');
    $g('#edit-content-slider-item-modal').modal();
});

$g('#content-slider-settings-dialog .sorting-container').on('click', '.zmdi.zmdi-edit', function(){
    var key = $g(this).closest('.sorting-item').attr('data-key');
    $g('.content-slider-item-title').val(sortingList[key].title);
    $g('#apply-content-slider-item').attr('data-key', key).attr('data-action', 'edit')
        .removeClass('active-button').addClass('disable-button');
    $g('#edit-content-slider-item-modal').modal();
});

$g('.content-slider-item-title').on('input', function(){
    if (this.value.trim()) {
        $g('#apply-content-slider-item').addClass('active-button').removeClass('disable-button');
    } else {
        $g('#apply-content-slider-item').removeClass('active-button').addClass('disable-button');
    }
});

$g('#apply-content-slider-item').on('click', function(event){
    event.preventDefault();
    if (this.dataset.action == 'edit') {
        sortingList[this.dataset.key].title = $g('.content-slider-item-title').val().trim();
        $g('#content-slider-settings-dialog .sorting-item[data-key="'+this.dataset.key+'"] .sorting-title')
            .text(sortingList[this.dataset.key].title);
        $g('#edit-content-slider-item-modal').modal('hide');
        var object = {
            data : app.edit,
            selector : app.editor.app.edit
        }
        app.editor.app.checkModule('initItems', object);
        app.addHistory();
    } else {
        $g.ajax({
            type: "POST",
            dataType: 'text',
            url: "index.php?option=com_gridbox&task=editor.loadLayout",
            data: {
                layout : 'section',
                count : '12'
            },
            complete: function(msg){
                msg = JSON.parse(msg.responseText);
                var key = '';
                for (var ind in msg.items) {
                    if (msg.items[ind].type == 'section') {
                        key = ind;
                    } else if (msg.items[ind].type == 'row') {
                        msg.items[ind].desktop.margin = {
                            "bottom" : "0",
                            "top" : "0"
                        }
                    }
                    app.editor.app.items[ind] = msg.items[ind];
                }
                app.sectionRules();
                app.editor.$g(app.selector+' > .slideset-wrapper > ul > .slideshow-content').append('<li class="item">'+msg.html+'</li>');
                var item = app.editor.document.getElementById(key);
                app.editor.editItem(key);
                app.editor.makeRowSortable($g(item).find('.ba-section-items'), 'row');
                app.editor.makeColumnSortable($g(item).find('.ba-grid-column'), 'column');
                app.editor.setColumnResizer(app.editor.document.getElementById(key));
                var obj = {
                    title: $g('.content-slider-item-title').val().trim()
                }
                sortingList.push(obj);
                app.edit.slides[sortingList.length - 1] = obj;
                var str = '<div class="sorting-item" data-key="'+(sortingList.length - 1)+
                    '"><div class="sorting-handle"><i class="zmdi zmdi-apps"></i></div><div class="sorting-title">'+
                    obj.title+'</div><div class="sorting-icons"><span><i class="zmdi zmdi-edit"></i>'+
                    '</span><span><i class="zmdi zmdi-delete"></i></span></div></div>';
                $g('#content-slider-settings-dialog .sorting-container').append(str);
                $g('#edit-content-slider-item-modal').modal('hide');
                var object = {
                    data : app.edit,
                    selector : app.editor.app.edit
                }
                app.editor.app.checkModule('initItems', object);
                app.addHistory();
            }
        });
    }    
});

$g('#content-slider-settings-dialog .sorting-container').on('click', '.zmdi.zmdi-delete', function(){
    app.itemDelete = $g(this).closest('.sorting-item').attr('data-key');
    app.checkModule('deleteItem');
});

if (!app.modules.draggable) {
    app.loadModule('draggable');
}
if (!app.modules.resizable) {
    app.loadModule('resizable');
}

app.modules.contentSliderEditor = true;
app.contentSliderEditor();