/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

app.imageEditor = function(){
    app.selector = '#'+app.editor.app.edit;
    $g('#image-settings-dialog .active').removeClass('active');
    $g('#image-settings-dialog a[href="#image-general-options"]').parent().addClass('active');
    $g('#image-general-options').addClass('active');
    $g('#image-settings-dialog .section-access-select input[type="hidden"]').val(app.edit.access);
    var value = $g('#image-settings-dialog .section-access-select li[data-value="'+app.edit.access+'"]').text();
    $g('#image-settings-dialog .section-access-select input[readonly]').val($g.trim(value));
    $g('#image-settings-dialog .class-suffix').val(app.edit.suffix);
    value = app.getValue('margin', 'top');
    $g('#image-settings-dialog [data-group="margin"][data-option="top"]').val(value);
    value = app.getValue('margin', 'bottom');
    $g('#image-settings-dialog [data-group="margin"][data-option="bottom"]').val(value);
    setDisableState('#image-settings-dialog');
    $g('#image-settings-dialog').find('.video-item-options, .ba-image-options').css('display', '');
    setPresetsList($g('#image-settings-dialog'));
    switch(app.edit.type) {
        case 'image' :
            if (!app.edit.desktop.overlay) {
                app.edit.desktop.overlay = {
                    type: 'none',
                    color: '@overlay',
                    gradient: {
                        effect : 'linear',
                        angle: '225',
                        color1: 'rgba(8, 174, 234, 0.75)',
                        position1: '0',
                        color2: 'rgba(42, 245, 152, 0.75)',
                        position2: '100'
                    }
                }
                app.edit.desktop.title = {
                    "typography" : {
                        "color" : "@title-inverse",
                        "font-family" : "@default",
                        "font-size" : 32,
                        "font-style" : "normal",
                        "font-weight" : "900",
                        "letter-spacing" : 0,
                        "line-height" : 42,
                        "text-decoration" : "none",
                        "text-align" : "center",
                        "text-transform" : "none"
                    },
                    "margin" : {
                        "bottom" : "0",
                        "top" : "0"
                    }
                };
                app.edit.desktop.description = {
                    "typography" : {
                        "color" : "@title-inverse",
                        "font-family" : "@default",
                        "font-size" : 21,
                        "font-style" : "normal",
                        "font-weight" : "300",
                        "letter-spacing" : 0,
                        "line-height" : 36,
                        "text-decoration" : "none",
                        "text-align" : "center",
                        "text-transform" : "none"
                    },
                    "margin" : {
                        "bottom" : "0",
                        "top" : "0"
                    }
                };
                app.edit.desktop.animation = {
                    "effect": "ba-fade",
                    "duration": 0.3
                }
                app.sectionRules();
            }
            if (!('embed' in app.edit)) {
                app.edit.embed = '';
            }
            if (!app.edit.tag) {
                app.edit.tag = 'h3';
            }
            var src = app.edit.image,
                array = src.split('/'),
                str = '<div class="sorting-item"><div class="sorting-image">';                
            if (src.indexOf('balbooa.com') == -1) {
                src = JUri+src;
            }
            str += '<img src="'+src+'"></div><div class="sorting-title">'+array[array.length - 1]+
                '</div><div class="sorting-icons"><span><i class="zmdi zmdi-edit"></i></span></div></div>';
            $g('#image-settings-dialog .sorting-container').html(str);
            value = app.getValue('overlay', 'effect', 'gradient');
            $g('#image-settings-dialog .overlay-linear-gradient').hide();
            $g('#image-settings-dialog .overlay-'+value+'-gradient').css('display', '');
            $g('#image-settings-dialog .overlay-gradient-options .gradient-effect-select input[type="hidden"]').val(value);
            value = $g('#image-settings-dialog .overlay-gradient-options .gradient-effect-select li[data-value="'+value+'"]').text().trim();
            $g('#image-settings-dialog .overlay-gradient-options .gradient-effect-select input[type="text"]').val(value);
            value = app.getValue('overlay', 'type');
            $g('#image-settings-dialog .overlay-color-options, .overlay-gradient-options').hide();
            $g('#image-settings-dialog .overlay-'+value+'-options').css('display', '');
            $g('#image-settings-dialog .background-overlay-select input[type="hidden"]').val(value);
            value = $g('#image-settings-dialog .background-overlay-select li[data-value="'+value+'"]').text().trim();
            $g('#image-settings-dialog .background-overlay-select input[type="text"]').val(value);
            $g('#image-settings-dialog .slideshow-style-custom-select input[type="hidden"]').val('title');
            $g('#image-settings-dialog .slideshow-style-custom-select input[readonly]').val(gridboxLanguage['TITLE']);
            $g('#image-settings-dialog .select-title-html-tag input[type="hidden"]').val(app.edit.tag);
            $g('#image-settings-dialog .select-title-html-tag input[readonly]').val(app.edit.tag.toUpperCase());
            showSlideshowDesign('title', $g('#image-settings-dialog .slideshow-style-custom-select'));
            $g('#image-settings-dialog').find('[data-group="overlay"],[data-group="animation"]').each(function(){
                if (this.dataset.subgroup) {
                    value = app.getValue(this.dataset.group, this.dataset.option, this.dataset.subgroup);
                } else if (this.dataset.group) {
                    value = app.getValue(this.dataset.group, this.dataset.option);
                } else {
                    value = app.getValue(this.dataset.option);
                }
                if (this.dataset.type == 'color') {
                    updateInput($g(this), value);
                } else if (this.type == 'hidden') {
                    this.value = value;
                    value = this.parentNode.querySelector('li[data-value="'+value+'"]').textContent.trim();
                    this.previousElementSibling.value = value;
                } else {
                    this.value = value;
                    if (this.type == 'number') {
                        var range = $g(this).prev();
                        range.val(value);
                        setLinearWidth(range);
                    }
                }
            });
            $g('#image-settings-dialog .video-item-options').hide();
            $g('#image-settings-dialog [data-option="align"].active').removeClass('active');
            value = app.getValue('style', 'align');
            $g('#image-settings-dialog [data-option="align"][data-value="'+value+'"]').addClass('active');
            value = app.getValue('style', 'width');
            value = $g('#image-settings-dialog .image-width input[data-option="width"]').val(value).prev().val(value);
            setLinearWidth(value);
            $g('#image-settings-dialog [data-option="link"]').val(app.edit.link.link);
            $g('#image-settings-dialog .link-target-select input[type="hidden"]').val(app.edit.link.target);
            value = $g('#image-settings-dialog .link-target-select li[data-value="'+app.edit.link.target+'"]').text();
            $g('#image-settings-dialog .link-target-select input[readonly]').val($g.trim(value));
            if (!app.edit.link.type) {
                app.edit.link.type = '';
            }
            $g('#image-settings-dialog .link-type-select input[type="hidden"]').val(app.edit.link.type);
            value = $g('#image-settings-dialog .link-type-select li[data-value="'+app.edit.link.type+'"]').text();
            $g('#image-settings-dialog .link-type-select input[readonly]').val($g.trim(value));
            $g('#image-settings-dialog [data-option="popup"]').prop('checked', app.edit.popup);
            value = app.edit.lightbox.color;
            updateInput($g('#image-settings-dialog input[data-option="color"][data-group="lightbox"]'), value);
            $g('#image-settings-dialog .button-embed-code').val(app.edit.embed);
            break;
        case 'video':
            $g('#image-settings-dialog .ba-image-options').hide();
            $g('.select-video-source input[type="hidden"]').val(app.edit.video.type);
            value = $g('.select-video-source li[data-value="'+app.edit.video.type+'"]').text().trim();
            $g('.select-video-source input[type="text"]').val(value);
            $g('.video-item-options input[data-option="id"]').val(app.edit.video.id);
            for (var ind in app.edit.video.vimeo) {
                $g('.video-item-options input[data-option="'+ind+'"][data-subgroup="video"]').prop('checked', app.edit.video.vimeo[ind]);
            }
            for (var ind in app.edit.video.youtube) {
                var input = $g('.video-item-options input[data-option="'+ind+'"][data-subgroup="youtube"]')
                if (ind != 'start') {
                    input.prop('checked', app.edit.video.youtube[ind]);
                } else {
                    input.val(app.edit.video.youtube[ind]);
                }
            }
            for (var ind in app.edit.video.source) {
                var input = $g('.video-item-options input[data-option="'+ind+'"][data-subgroup="source"]');
                if (ind != 'file') {
                    input.prop('checked', app.edit.video.source[ind]);
                } else {
                    input.val(app.edit.video.source[ind]);
                }
            }
            $g('.video-vimeo-options, .video-youtube-options, .video-source-options').hide();
            if (app.edit.video.type != 'source') {
                $g('#image-settings-dialog .video-id').css('display', '');
            } else {
                $g('#image-settings-dialog .video-id').hide();
            }
            $g('.video-'+app.edit.video.type+'-options').css('display', '');
            break;
    }
    value = app.getValue('shadow', 'value');
    value = $g('#image-settings-dialog input[data-option="value"][data-group="shadow"]').val(value).prev().val(value);
    setLinearWidth(value);
    value = app.getValue('shadow', 'color');
    updateInput($g('#image-settings-dialog input[data-option="color"][data-group="shadow"]'), value);
    value = app.getValue('border', 'radius');
    value = $g('#image-settings-dialog input[data-option="radius"][data-group="border"]').val(value).prev().val(value);
    setLinearWidth(value);
    value = app.getValue('border', 'width');
    value = $g('#image-settings-dialog input[data-option="width"][data-group="border"]').val(value).prev().val(value);
    setLinearWidth(value);
    value = app.getValue('border', 'color');
    updateInput($g('#image-settings-dialog input[data-option="color"][data-group="border"]'), value);
    value = app.getValue('border', 'style');
    $g('#image-settings-dialog .border-style-select input[type="hidden"]').val(value);
    value = $g('#image-settings-dialog .border-style-select li[data-value="'+value+'"]').text();
    $g('#image-settings-dialog .border-style-select input[readonly]').val($g.trim(value));
    $g('#image-settings-dialog').attr('data-edit', app.edit.type);
    setTimeout(function(){
        $g('#image-settings-dialog').modal();
    }, 150);
}

function setItemVideo()
{
    app.editor.$g(app.selector+' .ba-video-wrapper video').removeAttr('autoplay');
    if (app.edit.video.type != 'source') {
        var iframe = app.editor.document.querySelector(app.selector+' iframe'),
            src = 'https://www.youtube.com/embed/',
            obj = app.edit.video[app.edit.video.type];
        if (!iframe) {
            iframe = '<iframe src="" frameborder="0" allowfullscreen></iframe>';
            app.editor.document.querySelector(app.selector+' .ba-video-wrapper').innerHTML = iframe;
            iframe = app.editor.document.querySelector(app.selector+' iframe')
        }
        if (app.edit.video.type == 'vimeo') {
            src = 'https://player.vimeo.com/video/';
        }
        src += app.edit.video.id+'?';
        for (var ind in obj) {
            src += ind+'='+String(Number(obj[ind]))+'&';
        }
        iframe.src = src.substr(0, src.length - 1);
    } else {
        var obj = app.edit.video.source,
            video = '<video><source src="'+obj.file+'" type="video/mp4"></video>';
        app.editor.document.querySelector(app.selector+' .ba-video-wrapper').innerHTML = video;
        video = app.editor.document.querySelector(app.selector+' video');
        for (var ind in obj) {
            if (ind == 'autoplay' || ind == 'file') {
                continue;
            }
            if (obj[ind]) {
                video.setAttribute(ind, '');
            } else {
                video.removeAttribute(ind);
            }
        }
        var object = {
            data : app.edit,
            selector : app.editor.app.edit
        };
        app.editor.app.checkModule('initvideo', object);
    }
    app.addHistory();
}

$g('input[data-option="file"][data-group="video"]').on('click', function(){
    fontBtn = this;
    uploadMode = 'videoSource';
    checkIframe($g('#uploader-modal').attr('data-check', 'single'), 'uploader');
}).on('change', function(){
    app.edit.video.source.file = this.value;
    setItemVideo();
});

$g('.select-video-source').on('customAction', function(){
    app.edit.video.type = $g(this).find('input[type="hidden"]').val();
    app.edit.video.id = '';
    app.edit.video.source.file = '';
    setItemVideo();
    $g('.video-vimeo-options, .video-youtube-options, .video-source-options').hide();
    if (app.edit.video.type != 'source') {
        $g('#image-settings-dialog .video-id').css('display', '');
    } else {
        $g('#image-settings-dialog .video-id').hide();
    }
    $g('.video-'+app.edit.video.type+'-options').css('display', '').addClass('ba-active-options');
    $g('.video-item-options').find('input[data-option="id"], input[data-option="file"]').val('');
    setTimeout(function(){
        $g('.video-item-options .ba-active-options').removeClass('ba-active-options');
    }, 1);
});

$g('.video-item-options input[type="checkbox"]').on('change', function(){
    app.edit.video[this.dataset.subgroup][this.dataset.option] = this.checked;
    setItemVideo();
});

$g('.video-item-options input[data-option="start"]').on('input', function(){
    clearTimeout(delay);
    var $this = this;
    delay = setTimeout(function(){
        app.edit.video.youtube.start = $this.value;
        setItemVideo();
    }, 300);
});

$g('.video-item-options input[data-option="id"]').on('input', function(){
    clearTimeout(delay);
    var $this = this;
    delay = setTimeout(function(){
        app.edit.video.id = $this.value;
        setItemVideo();
    }, 300);
});

if (!app.modules.draggable) {
    app.loadModule('draggable');
}
if (!app.modules.resizable) {
    app.loadModule('resizable');
}

app.modules.imageEditor = true;
app.imageEditor();