/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

app.textEditor = function() {
    $g('#text-editor-dialog .active').removeClass('active');
    $g('#text-editor-dialog a[href="#text-editor-general-options"]').parent().addClass('active');
    $g('#text-editor-general-options').addClass('active');
    app.selector = '#'+app.editor.app.edit;
    var array = new Array('h1' ,'h2', 'h3', 'h4', 'h5', 'h6', 'p', 'links');
    if (app.edit.global) {
        delete(app.edit.global);
        array.forEach(function(el){
            delete(app.edit.desktop[el]);
            for (var ind in app.editor.breakpoints) {
                delete(app.edit[ind][el]);
            }
        });
    }
    if (!app.edit.desktop.p) {
        array.forEach(function(el){
            if (el != 'links') {
                app.edit.desktop[el] = {
                    "font-family" : "@default",
                    "font-style" : "@default"
                };
                for (var ind in app.editor.breakpoints) {
                    app.edit[ind][el] = {};
                }
            }
        });
    }
    if (!app.edit.desktop.links) {
        app.edit.desktop.links = {};
    }
    value = app.editor.document.querySelector(app.selector+' > .content-text > *');
    if (value) {
        value = value.localName;
        if (array.indexOf(value) == -1) {
            value = 'h1';
        }
    } else {
        value = 'h1';
    }
    $g('#text-editor-dialog .typography-select input[type="hidden"]').val(value);
    $g('#text-editor-dialog .typography-select input[type="text"]').val(value.toUpperCase().replace('P', 'Paragraph'));
    app.setTypography($g('#text-editor-dialog .typography-options'), value);
    $g('#text-editor-dialog .typography-options .ba-settings-item').css('display', '').last().hide().prev().hide();
    $g('#text-editor-dialog .section-access-select input[type="hidden"]').val(app.edit.access);
    var value = $g('#text-editor-dialog .section-access-select li[data-value="'+app.edit.access+'"]').text();
    $g('#text-editor-dialog .section-access-select input[readonly]').val($g.trim(value));
    $g('#text-editor-dialog .class-suffix').val(app.edit.suffix);
    value = app.getValue('margin', 'top');
    $g('#text-editor-dialog [data-group="margin"][data-option="top"]').val(value);
    value = app.getValue('margin', 'bottom');
    $g('#text-editor-dialog [data-group="margin"][data-option="bottom"]').val(value);
    setDisableState('#text-editor-dialog');
    setTimeout(function(){
        if ('WFEditor' in window || CKE.loaded) {
            app.setTextContent();
            $g('#text-editor-dialog').modal();
        }
    }, 150);
}

app.setTextContent = function(){
    var item = app.editor.document.querySelector(app.selector+' .content-text');
    app.setContent(item.innerHTML);
}

if ('WFEditor' in window) {
    app.setContent = function(data){
        WFEditor.setContent('editor', data);
    }
    tinyMCE.activeEditor.onKeyUp.add(function(){
        app.editor.document.querySelector(app.selector+' .content-text').innerHTML = WFEditor.getContent('editor');
    });
    tinyMCE.activeEditor.onChange.add(function(){
        app.editor.document.querySelector(app.selector+' .content-text').innerHTML = WFEditor.getContent('editor');
    });
    $g('#editor').on('keyup', function(){
        app.editor.document.querySelector(app.selector+' .content-text').innerHTML = WFEditor.getContent('editor');
    });
    document.querySelector('.ba-editor-wrapper').classList.add('jce-editor-enabled');
} else {
    var ckeImage = '',
        CKE = CKEDITOR.replace('editor'),
        ckeImageModal = $g('#cke-image-modal');
    app.setContent = function(data){
        CKE.setData(data);
    }

    function addCKEImage(obj)
    {
        var doc = $g('.ba-editor-wrapper iframe')[0].contentDocument,
            img = '';
        if (obj.width) {
            obj.width += 'px';
        }
        if (obj.height) {
            obj.height += 'px';
        }
        if (ckeImage) {
            ckeImage.src = obj.url;
            ckeImage.alt = $g.trim(obj.alt);
            ckeImage.style.width = obj.width;
            ckeImage.style.height = obj.height;
            ckeImage.style.float = obj.align;
        } else {
            img = document.createElement('img');
            img.src = obj.url;
            img.alt = $g.trim(obj.alt);
            img.style.width = obj.width;
            img.style.height = obj.height;
            img.style.float = obj.align;
            if (doc.getSelection().rangeCount > 0) {
                var range = doc.getSelection().getRangeAt(0);
                range.insertNode(img);
            } else {
                var data = CKE.getData();
                data += img.outerHTML;
                CKE.setData(data);
            }
        }
        app.editor.document.querySelector(app.selector+' .content-text').innerHTML = CKE.getData();
        app.addHistory();
    }

    function getCKECSSrulesString()
    {
        var str = 'body.cke_editable';
        str += ' {font-family: Arial, Helevtica, sans-serif;}';
        str += ' body.cke_editable img {max-width: 100%;}';
        str += 'a { text-decoration: none; } :focus { outline: none; }';

        return str;
    }

    if ($g('html').attr('dir') == 'rtl') {
        CKEDITOR.config.contentsLangDirection = 'rtl';
    }
    CKE.setUiColor('#fafafa');
    CKE.config.allowedContent = true;
    CKEDITOR.dtd.$removeEmpty.span = 0;
    CKEDITOR.dtd.$removeEmpty.i = 0;
    CKE.config.toolbar_Basic =
    [
        {name: 'document', items: ['Source']},
        {name: 'styles', items: ['Styles','Format']},
        {name: 'colors', items: ['TextColor']},
        {name: 'clipboard', items: ['Undo','Redo']},
        {name: 'basicstyles', items: ['Bold','Italic','Underline']},
        {name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent',
            'Indent', '-', 'Blockquote', '-', 'JustifyLeft', 'JustifyCenter','JustifyRight', 'JustifyBlock', '-']},
        {name: 'links', items: ['Link','Unlink','Anchor']},
        {name: 'insert', items: ['myImage','Table','HorizontalRule']}
    ];
    CKE.config.toolbar = 'Basic';
    CKEDITOR.config.removePlugins = 'image';
    CKE.addCommand("imgComand", {
        exec: function(edt) {
            var align = src = w = h = alt = label = '',
                selected = CKE.getSelection().getSelectedElement();
            if (selected && selected.$.localName == 'img') {
                ckeImage = selected.$;
                src = ckeImage.src;
                alt = ckeImage.alt;
                w = ckeImage.style.width.replace('px', '');
                h = ckeImage.style.height.replace('px', '');
                align = ckeImage.style.float;
                label = ckeImageModal.find('.cke-image-select li[data-value="'+align+'"]').text();
                label = $g.trim(label);
            } else {
                ckeImage = '';
            }
            ckeImageModal.find('.cke-upload-image').val(src);
            ckeImageModal.find('.cke-image-alt').val(alt);
            ckeImageModal.find('.cke-image-width').val(w);
            ckeImageModal.find('.cke-image-height').val(h);
            ckeImageModal.find('#cke-image-align').val(align);
            ckeImageModal.find('.cke-image-align').val(label);
            app.checkModule('ckeImage');
        }
    });
    CKE.ui.addButton('myImage', {
        label: "Image",
        command: 'imgComand',
        toolbar: 'insert',
        icon: 'image'
    });
    CKEDITOR.config.contentsCss = [getCKECSSrulesString()];
    CKE.on('change', function(){
        app.editor.document.querySelector(app.selector+' .content-text').innerHTML = CKE.getData();
        clearTimeout(this.gridboxDelay);
        this.gridboxDelay = setTimeout(function(){
            app.addHistory();
        }, 300);
    });
    CKE.on('loaded', function(){
        $g('#cke_1_contents').on('keyup', 'textarea', function(){
            app.editor.document.querySelector(app.selector+' .content-text').innerHTML = CKE.getData();
            clearTimeout(CKE.gridboxDelay);
            CKE.gridboxDelay = setTimeout(function(){
                app.addHistory();
            }, 300);
        });
    });
    CKE.on('instanceReady', function(){
        app.setTextContent();
        $g('#text-editor-dialog').modal();
    });
}

$g('#text-editor-dialog .resize-text-editor').on('mousedown', function(event){
    event.preventDefault();
    event.stopPropagation();
    var $this = $g(this),
        modal = $g('#text-editor-dialog'),
        offset = modal[0].getBoundingClientRect();
        left = offset.left,
        right = document.documentElement.clientWidth - offset.right;
    if (left + 970 > document.documentElement.clientWidth) {
        left = 'auto';
    } else {
        right = 'auto';
    }
    if ($this.hasClass('zmdi-fullscreen')) {
        $this.removeClass('zmdi-fullscreen').addClass('zmdi-fullscreen-exit');
        modal.css({
            left : left,
            right : right,
            position: 'fixed',
            'margin-left': 0
        });
        if (left == 'auto' && offset.right - 970 < 0) {
            modal.animate({
                'right': document.documentElement.clientWidth - 995
            }, 300);
        }
        modal.addClass('text-editor-resized').addClass('text-editor-animation');
        setTimeout(function(){
            modal.removeClass('text-editor-animation');
        }, 300);
    } else {
        $this.removeClass('zmdi-fullscreen-exit').addClass('zmdi-fullscreen');
        modal.removeClass('text-editor-resized').addClass('text-editor-animation');
        setTimeout(function(){
            modal.removeClass('text-editor-animation');
            offset = modal[0].getBoundingClientRect();
            modal.css({
                left : offset.left,
                right : '',
            });
        }, 300);
    }
})

if (!app.modules.draggable) {
    app.loadModule('draggable');
}
if (!app.modules.resizable) {
    app.loadModule('resizable');
}

app.modules.textEditor = true;
app.textEditor();