<?php
/**
* @package   Gridbox
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die;

jimport('joomla.application.component.view');

class gridboxViewUploader extends JViewLegacy
{
    protected $_folders;
    protected $_images;
    protected $_items;
    protected $_parent;
    protected $_list;
    protected $_breadcrumb;
    protected $_move_to = array();
    protected $_page = 0;
    protected $_pages = 1;
    protected $_limit = 25;
    protected $about;
    protected $_imagesExt;
    protected $fileTypes;
    protected $folder;
    
    public function display ($tpl = null)
    {
        if (!JFactory::getUser()->authorise('core.edit', 'com_gridbox')) {
            JError::raiseWarning(403, JText::_('JERROR_ALERTNOAUTHOR'));
            return;
        }
        if (count($errors = $this->get('Errors'))) {
            JError::raiseError(500, implode('<br />', $errors));
            return false;
        }
        $this->fileTypes = $this->get('fileTypes');
        $doc = JFactory::getDocument();
        $doc->addStyleSheet('//fonts.googleapis.com/css?family=Roboto:300,400,500,700');
        $doc->addScript(JUri::root(true) . '/media/jui/js/jquery.min.js');
        $doc->addScript(JUri::root(true) . '/media/jui/js/bootstrap.min.js');
        $doc->addScriptDeclaration('var $fileTypes = '.json_encode($this->fileTypes).';');
        $this->_folders = $this->get('Folders');
        $this->_images = $this->get('Images');
        $this->_items = array_merge($this->_folders, $this->_images);
        $this->_imagesExt = array('jpg', 'png', 'gif', 'jpeg', 'svg', 'ico');
        $this->_parent = $this->get('parent');
        $this->folder = '';
        $this->about = gridboxHelper::aboutUs();
        $this->addToolBar();
        $this->drawPagination();
        if (is_array($this->_folders)) {
            $this->_breadcrumb = $this->get('Breadcrumb');
        }
        if ($doc->getDirection() == 'rtl') {
            $doc->addStyleSheet(JUri::root().'components/com_gridbox/assets/css/rtl-ba-style.css?'.$this->about->version);
        }
        if (!JFactory::getUser()->authorise('core.edit', 'com_gridbox')) {
            return JError::raiseError(404, JText::_('NOT_FOUND'));
        }
        $doc->setTitle('Gridbox Editor');
        $this->_list = $this->get('FolderList');
        $this->_list = $this->drawFolderList($this->_list);
        parent::display($tpl);
    }

    protected function drawPagination()
    {
        $input = JFactory::getApplication()->input;
        $page = $input->get('page', '', 'string');
        if (!empty($page)) {
            $this->_page = $page * 1;
        }
        $limit = $input->get('ba_limit', '', 'string');
        if (!$limit) {
            $limit = 25;
        }
        $this->_limit = $limit;
        $count = count($this->_items);
        $this->_pages = ceil($count / $limit);
        if ($limit == 1) {
            $this->_pages = 1;
        }
        if ($this->_pages > 1) {
            $this->_items = array_slice($this->_items, $this->_page * $limit, $limit);
        }
    }

    protected function drawFolderList($list)
    {
        $str = '<ul>';
        foreach ($list as $value) {
            $str .= '<li data-path="'.$value->path.'"';            
            if ($this->_parent == JPATH_ROOT. '/images'.$value->path) {
                $this->folder = $value->path;
                $str .= ' class="active"';
            }
            if (!empty($this->_breadcrumb) && in_array($value->path, $this->_breadcrumb->path)) {
                $str .= ' class="visible-branch"';
            }
            $str .= '><a data-href="folder='.$value->path;
            if (isset($_GET['layout']) && $_GET['layout'] == 'thubnail') {
                $str .= '&layout=thubnail';
            }
            $str .= '&tmpl=component" ><i class="zmdi zmdi-folder"></i> '.$value->name.'</a>';
            if (count($value->childs) > 0) {
                $str .= '<i class="zmdi zmdi-chevron-right"></i>';
                $str .= $this->drawFolderList($value->childs);
            }
            $str .= '</li>';
        }
        $str .= '</ul>';

        return $str;
    }

    protected function getFileSize($size)
    {
        $size = $size / 1024;
        $size = floor($size);
        if ($size >= 1024) {
            $size = $size / 1024;
            $size = floor($size);
            $size = (string)$size .' MB';
        } else {
            $size = (string)$size .' KB';
        }

        return $size;
    }

    protected function addToolBar()
    {
        $input = JFactory::getApplication()->input;
        $input->set('hidemainmenu', true);
    }
}