<?php
/**
* @package   Gridbox template
* @author    Balbooa http://www.balbooa.com/
* @copyright Copyright @ Balbooa
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die;

$app = JFactory::getApplication();
$doc = JFactory::getDocument();
$this->language = $doc->language;
$this->direction = $doc->direction;
$id = 2;
JLoader::register('gridboxHelper', JPATH_ROOT . '/components/com_gridbox/helpers/gridbox.php');
gridboxHelper::checkSystemTheme(2);
gridboxHelper::setBreakpoints();
gridboxHelper::checkResponsive();
gridboxHelper::checkGridboxLanguage();
$id = gridboxHelper::getTheme(2, false, 'system');
$data = array('id' => 2, 'theme' => $id, 'edit_type' => 'system');
$page = new stdClass();
$page->option = 'com_gridbox';
$page->view = 'page';
$page->id = 2;
$data['page'] = $page;
$this->params = gridboxHelper::getThemeParams($id);
$params = $this->params->get('params');
$item = gridboxHelper::getSystemParams(2);
$item->html = gridboxHelper::checkModules($item->html, $item->items);
gridboxHelper::prepareParentFonts($params);
gridboxHelper::checkSystemCss(2);
$time = $this->params->get('time', '');
if (!empty($time)) {
    $time = '?'.$time;
}
$fonts = '{}';
$fonts = gridboxHelper::prepareFonts($fonts, 'com_gridbox', 2, 'system');
$style = gridboxHelper::checkCustom($id, 'page', $time);
$website = gridboxHelper::getWebsiteCode();
$doc->addScript(JUri::root() . 'media/jui/js/jquery.min.js');
$doc->addScript(JUri::root() . 'media/jui/js/bootstrap.min.js');
$doc->addScriptDeclaration("var JUri = '".JUri::root()."';");
$doc->addScript($this->baseurl . '/templates/gridbox/js/gridbox.js');
$doc->addScriptDeclaration("var themeData = ".json_encode($data).";");
$doc->addStyleSheet($this->baseurl . '/templates/gridbox/css/gridbox.css');
$doc->addStyleSheet($this->baseurl . '/templates/gridbox/css/storage/responsive.css'.$time);
$doc->addStyleSheet(JUri::root().'templates/gridbox/css/storage/style-'.$id.'.css'.$time);
$doc->addStyleSheet(JUri::root().'templates/gridbox/css/storage/offline.css'.$time);
if (!empty($fonts)) {
    $doc->addStyleSheet($fonts);
}
$breakpoints = json_encode(gridboxHelper::$breakpoints);
$disable_responsive = gridboxHelper::$website->disable_responsive == 1 ? 'true' : 'false';
$doc->addScriptDeclaration("var breakpoints = ".$breakpoints.";");
$doc->addScriptDeclaration("var menuBreakpoint = ".gridboxHelper::$menuBreakpoint.";");
$doc->addScriptDeclaration("var disableResponsive = ".$disable_responsive.";");
$stylesheets = gridboxHelper::returnSystemStyle($doc);

gridboxHelper::createFavicon();
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>"
    dir="<?php echo $this->direction; ?>">
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <title><?php echo $item->title; ?></title>
<?php
    if (!(bool)gridboxHelper::$website->disable_responsive) {
?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
<?php
    } else {
?>
    <meta name="viewport" content="width=device-width">
<?php
    }
    if ($this->direction == 'rtl') { ?>
    <link rel="stylesheet" href="<?php echo $this->baseurl; ?>/media/jui/css/bootstrap-rtl.css" type="text/css" />
<?php
    }
?>
    <link href="<?php echo $this->baseurl; ?>/templates/gridbox/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />
<?php
    echo $stylesheets;
    echo "\n".$website->header_code; 
    echo $style."\n";
?>
</head>
<body class="com_gridbox page">
    <div class="ba-overlay"></div>
    <div class="body">
        <div class="row-fluid main-body">
            <div class="span12">
<?php
if (JFactory::getUser()->authorise('core.edit', 'com_gridbox')) {
?>
            <a class="edit-page-btn" target="_blank"
               href="<?php echo JUri::root().'index.php?option=com_gridbox&view=editor&edit_type=system&tmpl=component&id=2'; ?>">
               <i class="zmdi zmdi-settings"></i>
               <p class="edit-page"><?php echo JText::_('EDIT_PAGE'); ?></p>
            </a>
<?php
}
            echo $item->html;
?>
            </div>
        </div>
    </div>
<?php
if ($params->desktop->background->type == 'video') {
?>
    <div class="ba-video-background global-video-bg"></div>
<?php
}
?>
<?php
echo $website->body_code."\n";
?>
</body>
</html>
